package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

/**
 * Fields to access customer accounts. Includes direct access to a single customer and searching for customers.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes(@JsonSubTypes.Type(value = InStore.class, name = "InStore"))
public interface CustomerQueryInterface {
  Customer getCustomer();

  void setCustomer(Customer customer);

  CustomerQueryResult getCustomers();

  void setCustomers(CustomerQueryResult customers);
}
