package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class CustomerSignInDraft {
  private String email;

  private String password;

  /**
   * This field will be deprecated in favour of anonymousCart.id.
   */
  private String anonymousCartId;

  private ResourceIdentifierInput anonymousCart;

  private AnonymousCartSignInMode anonymousCartSignInMode = AnonymousCartSignInMode.MergeWithExistingCustomerCart;

  private String anonymousId;

  private Boolean updateProductData = false;

  public CustomerSignInDraft() {
  }

  public CustomerSignInDraft(String email, String password, String anonymousCartId,
      ResourceIdentifierInput anonymousCart, AnonymousCartSignInMode anonymousCartSignInMode,
      String anonymousId, Boolean updateProductData) {
    this.email = email;
    this.password = password;
    this.anonymousCartId = anonymousCartId;
    this.anonymousCart = anonymousCart;
    this.anonymousCartSignInMode = anonymousCartSignInMode;
    this.anonymousId = anonymousId;
    this.updateProductData = updateProductData;
  }

  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public String getPassword() {
    return password;
  }

  public void setPassword(String password) {
    this.password = password;
  }

  /**
   * This field will be deprecated in favour of anonymousCart.id.
   */
  public String getAnonymousCartId() {
    return anonymousCartId;
  }

  public void setAnonymousCartId(String anonymousCartId) {
    this.anonymousCartId = anonymousCartId;
  }

  public ResourceIdentifierInput getAnonymousCart() {
    return anonymousCart;
  }

  public void setAnonymousCart(ResourceIdentifierInput anonymousCart) {
    this.anonymousCart = anonymousCart;
  }

  public AnonymousCartSignInMode getAnonymousCartSignInMode() {
    return anonymousCartSignInMode;
  }

  public void setAnonymousCartSignInMode(AnonymousCartSignInMode anonymousCartSignInMode) {
    this.anonymousCartSignInMode = anonymousCartSignInMode;
  }

  public String getAnonymousId() {
    return anonymousId;
  }

  public void setAnonymousId(String anonymousId) {
    this.anonymousId = anonymousId;
  }

  public Boolean getUpdateProductData() {
    return updateProductData;
  }

  public void setUpdateProductData(Boolean updateProductData) {
    this.updateProductData = updateProductData;
  }

  @Override
  public String toString() {
    return "CustomerSignInDraft{email='" + email + "', password='" + password + "', anonymousCartId='" + anonymousCartId + "', anonymousCart='" + anonymousCart + "', anonymousCartSignInMode='" + anonymousCartSignInMode + "', anonymousId='" + anonymousId + "', updateProductData='" + updateProductData + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerSignInDraft that = (CustomerSignInDraft) o;
    return Objects.equals(email, that.email) &&
        Objects.equals(password, that.password) &&
        Objects.equals(anonymousCartId, that.anonymousCartId) &&
        Objects.equals(anonymousCart, that.anonymousCart) &&
        Objects.equals(anonymousCartSignInMode, that.anonymousCartSignInMode) &&
        Objects.equals(anonymousId, that.anonymousId) &&
        Objects.equals(updateProductData, that.updateProductData);
  }

  @Override
  public int hashCode() {
    return Objects.hash(email, password, anonymousCartId, anonymousCart, anonymousCartSignInMode, anonymousId, updateProductData);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String email;

    private String password;

    /**
     * This field will be deprecated in favour of anonymousCart.id.
     */
    private String anonymousCartId;

    private ResourceIdentifierInput anonymousCart;

    private AnonymousCartSignInMode anonymousCartSignInMode = AnonymousCartSignInMode.MergeWithExistingCustomerCart;

    private String anonymousId;

    private Boolean updateProductData = false;

    public CustomerSignInDraft build() {
      CustomerSignInDraft result = new CustomerSignInDraft();
      result.email = this.email;
      result.password = this.password;
      result.anonymousCartId = this.anonymousCartId;
      result.anonymousCart = this.anonymousCart;
      result.anonymousCartSignInMode = this.anonymousCartSignInMode;
      result.anonymousId = this.anonymousId;
      result.updateProductData = this.updateProductData;
      return result;
    }

    public Builder email(String email) {
      this.email = email;
      return this;
    }

    public Builder password(String password) {
      this.password = password;
      return this;
    }

    /**
     * This field will be deprecated in favour of anonymousCart.id.
     */
    public Builder anonymousCartId(String anonymousCartId) {
      this.anonymousCartId = anonymousCartId;
      return this;
    }

    public Builder anonymousCart(ResourceIdentifierInput anonymousCart) {
      this.anonymousCart = anonymousCart;
      return this;
    }

    public Builder anonymousCartSignInMode(AnonymousCartSignInMode anonymousCartSignInMode) {
      this.anonymousCartSignInMode = anonymousCartSignInMode;
      return this;
    }

    public Builder anonymousId(String anonymousId) {
      this.anonymousId = anonymousId;
      return this;
    }

    public Builder updateProductData(Boolean updateProductData) {
      this.updateProductData = updateProductData;
      return this;
    }
  }
}
