package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class CustomerSignInResult {
  private Customer customer;

  private Cart cart;

  public CustomerSignInResult() {
  }

  public CustomerSignInResult(Customer customer, Cart cart) {
    this.customer = customer;
    this.cart = cart;
  }

  public Customer getCustomer() {
    return customer;
  }

  public void setCustomer(Customer customer) {
    this.customer = customer;
  }

  public Cart getCart() {
    return cart;
  }

  public void setCart(Cart cart) {
    this.cart = cart;
  }

  @Override
  public String toString() {
    return "CustomerSignInResult{customer='" + customer + "', cart='" + cart + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerSignInResult that = (CustomerSignInResult) o;
    return Objects.equals(customer, that.customer) &&
        Objects.equals(cart, that.cart);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customer, cart);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Customer customer;

    private Cart cart;

    public CustomerSignInResult build() {
      CustomerSignInResult result = new CustomerSignInResult();
      result.customer = this.customer;
      result.cart = this.cart;
      return result;
    }

    public Builder customer(Customer customer) {
      this.customer = customer;
      return this;
    }

    public Builder cart(Cart cart) {
      this.cart = cart;
      return this;
    }
  }
}
