package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class CustomerSignMeInDraft {
  private String email;

  private String password;

  private AnonymousCartSignInMode activeCartSignInMode = AnonymousCartSignInMode.MergeWithExistingCustomerCart;

  private Boolean updateProductData = false;

  public CustomerSignMeInDraft() {
  }

  public CustomerSignMeInDraft(String email, String password,
      AnonymousCartSignInMode activeCartSignInMode, Boolean updateProductData) {
    this.email = email;
    this.password = password;
    this.activeCartSignInMode = activeCartSignInMode;
    this.updateProductData = updateProductData;
  }

  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public String getPassword() {
    return password;
  }

  public void setPassword(String password) {
    this.password = password;
  }

  public AnonymousCartSignInMode getActiveCartSignInMode() {
    return activeCartSignInMode;
  }

  public void setActiveCartSignInMode(AnonymousCartSignInMode activeCartSignInMode) {
    this.activeCartSignInMode = activeCartSignInMode;
  }

  public Boolean getUpdateProductData() {
    return updateProductData;
  }

  public void setUpdateProductData(Boolean updateProductData) {
    this.updateProductData = updateProductData;
  }

  @Override
  public String toString() {
    return "CustomerSignMeInDraft{email='" + email + "', password='" + password + "', activeCartSignInMode='" + activeCartSignInMode + "', updateProductData='" + updateProductData + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerSignMeInDraft that = (CustomerSignMeInDraft) o;
    return Objects.equals(email, that.email) &&
        Objects.equals(password, that.password) &&
        Objects.equals(activeCartSignInMode, that.activeCartSignInMode) &&
        Objects.equals(updateProductData, that.updateProductData);
  }

  @Override
  public int hashCode() {
    return Objects.hash(email, password, activeCartSignInMode, updateProductData);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String email;

    private String password;

    private AnonymousCartSignInMode activeCartSignInMode = AnonymousCartSignInMode.MergeWithExistingCustomerCart;

    private Boolean updateProductData = false;

    public CustomerSignMeInDraft build() {
      CustomerSignMeInDraft result = new CustomerSignMeInDraft();
      result.email = this.email;
      result.password = this.password;
      result.activeCartSignInMode = this.activeCartSignInMode;
      result.updateProductData = this.updateProductData;
      return result;
    }

    public Builder email(String email) {
      this.email = email;
      return this;
    }

    public Builder password(String password) {
      this.password = password;
      return this;
    }

    public Builder activeCartSignInMode(AnonymousCartSignInMode activeCartSignInMode) {
      this.activeCartSignInMode = activeCartSignInMode;
      return this;
    }

    public Builder updateProductData(Boolean updateProductData) {
      this.updateProductData = updateProductData;
      return this;
    }
  }
}
