package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class CustomerSignUpDraft {
  private String email;

  private String password;

  private String firstName;

  private String lastName;

  private String middleName;

  private String title;

  private LocalDate dateOfBirth;

  private String companyName;

  private String vatId;

  private List<AddressInput> addresses = Collections.emptyList();

  /**
   * The index of the address in the `addresses` list. The `defaultBillingAddressId` of the customer will be set to the ID of that address.
   */
  private Integer defaultBillingAddress;

  /**
   * The index of the address in the `addresses` list. The `defaultShippingAddressId` of the customer will be set to the ID of that address.
   */
  private Integer defaultShippingAddress;

  /**
   * The indices of the shipping addresses in the `addresses` list. The `shippingAddressIds` of the `Customer` will be set to the IDs of that addresses.
   */
  private List<Integer> shippingAddresses = Collections.emptyList();

  /**
   * The indices of the billing addresses in the `addresses` list. The `billingAddressIds` of the customer will be set to the IDs of that addresses.
   */
  private List<Integer> billingAddresses = Collections.emptyList();

  private CustomFieldsDraft custom;

  private String locale;

  private String salutation;

  private String key;

  private List<ResourceIdentifierInput> stores;

  private String customerNumber;

  /**
   * This field will be deprecated in favour of anonymousCart.id.
   */
  private String anonymousCartId;

  private ResourceIdentifierInput anonymousCart;

  private String externalId;

  private ResourceIdentifierInput customerGroup;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private List<CustomerGroupAssignmentDraft> customerGroupAssignments;

  private Boolean isEmailVerified;

  private String anonymousId;

  private AuthenticationMode authenticationMode;

  public CustomerSignUpDraft() {
  }

  public CustomerSignUpDraft(String email, String password, String firstName, String lastName,
      String middleName, String title, LocalDate dateOfBirth, String companyName, String vatId,
      List<AddressInput> addresses, Integer defaultBillingAddress, Integer defaultShippingAddress,
      List<Integer> shippingAddresses, List<Integer> billingAddresses, CustomFieldsDraft custom,
      String locale, String salutation, String key, List<ResourceIdentifierInput> stores,
      String customerNumber, String anonymousCartId, ResourceIdentifierInput anonymousCart,
      String externalId, ResourceIdentifierInput customerGroup,
      List<CustomerGroupAssignmentDraft> customerGroupAssignments, Boolean isEmailVerified,
      String anonymousId, AuthenticationMode authenticationMode) {
    this.email = email;
    this.password = password;
    this.firstName = firstName;
    this.lastName = lastName;
    this.middleName = middleName;
    this.title = title;
    this.dateOfBirth = dateOfBirth;
    this.companyName = companyName;
    this.vatId = vatId;
    this.addresses = addresses;
    this.defaultBillingAddress = defaultBillingAddress;
    this.defaultShippingAddress = defaultShippingAddress;
    this.shippingAddresses = shippingAddresses;
    this.billingAddresses = billingAddresses;
    this.custom = custom;
    this.locale = locale;
    this.salutation = salutation;
    this.key = key;
    this.stores = stores;
    this.customerNumber = customerNumber;
    this.anonymousCartId = anonymousCartId;
    this.anonymousCart = anonymousCart;
    this.externalId = externalId;
    this.customerGroup = customerGroup;
    this.customerGroupAssignments = customerGroupAssignments;
    this.isEmailVerified = isEmailVerified;
    this.anonymousId = anonymousId;
    this.authenticationMode = authenticationMode;
  }

  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public String getPassword() {
    return password;
  }

  public void setPassword(String password) {
    this.password = password;
  }

  public String getFirstName() {
    return firstName;
  }

  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }

  public String getLastName() {
    return lastName;
  }

  public void setLastName(String lastName) {
    this.lastName = lastName;
  }

  public String getMiddleName() {
    return middleName;
  }

  public void setMiddleName(String middleName) {
    this.middleName = middleName;
  }

  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public LocalDate getDateOfBirth() {
    return dateOfBirth;
  }

  public void setDateOfBirth(LocalDate dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
  }

  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  public String getVatId() {
    return vatId;
  }

  public void setVatId(String vatId) {
    this.vatId = vatId;
  }

  public List<AddressInput> getAddresses() {
    return addresses;
  }

  public void setAddresses(List<AddressInput> addresses) {
    this.addresses = addresses;
  }

  /**
   * The index of the address in the `addresses` list. The `defaultBillingAddressId` of the customer will be set to the ID of that address.
   */
  public Integer getDefaultBillingAddress() {
    return defaultBillingAddress;
  }

  public void setDefaultBillingAddress(Integer defaultBillingAddress) {
    this.defaultBillingAddress = defaultBillingAddress;
  }

  /**
   * The index of the address in the `addresses` list. The `defaultShippingAddressId` of the customer will be set to the ID of that address.
   */
  public Integer getDefaultShippingAddress() {
    return defaultShippingAddress;
  }

  public void setDefaultShippingAddress(Integer defaultShippingAddress) {
    this.defaultShippingAddress = defaultShippingAddress;
  }

  /**
   * The indices of the shipping addresses in the `addresses` list. The `shippingAddressIds` of the `Customer` will be set to the IDs of that addresses.
   */
  public List<Integer> getShippingAddresses() {
    return shippingAddresses;
  }

  public void setShippingAddresses(List<Integer> shippingAddresses) {
    this.shippingAddresses = shippingAddresses;
  }

  /**
   * The indices of the billing addresses in the `addresses` list. The `billingAddressIds` of the customer will be set to the IDs of that addresses.
   */
  public List<Integer> getBillingAddresses() {
    return billingAddresses;
  }

  public void setBillingAddresses(List<Integer> billingAddresses) {
    this.billingAddresses = billingAddresses;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public String getLocale() {
    return locale;
  }

  public void setLocale(String locale) {
    this.locale = locale;
  }

  public String getSalutation() {
    return salutation;
  }

  public void setSalutation(String salutation) {
    this.salutation = salutation;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public List<ResourceIdentifierInput> getStores() {
    return stores;
  }

  public void setStores(List<ResourceIdentifierInput> stores) {
    this.stores = stores;
  }

  public String getCustomerNumber() {
    return customerNumber;
  }

  public void setCustomerNumber(String customerNumber) {
    this.customerNumber = customerNumber;
  }

  /**
   * This field will be deprecated in favour of anonymousCart.id.
   */
  public String getAnonymousCartId() {
    return anonymousCartId;
  }

  public void setAnonymousCartId(String anonymousCartId) {
    this.anonymousCartId = anonymousCartId;
  }

  public ResourceIdentifierInput getAnonymousCart() {
    return anonymousCart;
  }

  public void setAnonymousCart(ResourceIdentifierInput anonymousCart) {
    this.anonymousCart = anonymousCart;
  }

  public String getExternalId() {
    return externalId;
  }

  public void setExternalId(String externalId) {
    this.externalId = externalId;
  }

  public ResourceIdentifierInput getCustomerGroup() {
    return customerGroup;
  }

  public void setCustomerGroup(ResourceIdentifierInput customerGroup) {
    this.customerGroup = customerGroup;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public List<CustomerGroupAssignmentDraft> getCustomerGroupAssignments() {
    return customerGroupAssignments;
  }

  public void setCustomerGroupAssignments(
      List<CustomerGroupAssignmentDraft> customerGroupAssignments) {
    this.customerGroupAssignments = customerGroupAssignments;
  }

  public Boolean getIsEmailVerified() {
    return isEmailVerified;
  }

  public void setIsEmailVerified(Boolean isEmailVerified) {
    this.isEmailVerified = isEmailVerified;
  }

  public String getAnonymousId() {
    return anonymousId;
  }

  public void setAnonymousId(String anonymousId) {
    this.anonymousId = anonymousId;
  }

  public AuthenticationMode getAuthenticationMode() {
    return authenticationMode;
  }

  public void setAuthenticationMode(AuthenticationMode authenticationMode) {
    this.authenticationMode = authenticationMode;
  }

  @Override
  public String toString() {
    return "CustomerSignUpDraft{email='" + email + "', password='" + password + "', firstName='" + firstName + "', lastName='" + lastName + "', middleName='" + middleName + "', title='" + title + "', dateOfBirth='" + dateOfBirth + "', companyName='" + companyName + "', vatId='" + vatId + "', addresses='" + addresses + "', defaultBillingAddress='" + defaultBillingAddress + "', defaultShippingAddress='" + defaultShippingAddress + "', shippingAddresses='" + shippingAddresses + "', billingAddresses='" + billingAddresses + "', custom='" + custom + "', locale='" + locale + "', salutation='" + salutation + "', key='" + key + "', stores='" + stores + "', customerNumber='" + customerNumber + "', anonymousCartId='" + anonymousCartId + "', anonymousCart='" + anonymousCart + "', externalId='" + externalId + "', customerGroup='" + customerGroup + "', customerGroupAssignments='" + customerGroupAssignments + "', isEmailVerified='" + isEmailVerified + "', anonymousId='" + anonymousId + "', authenticationMode='" + authenticationMode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerSignUpDraft that = (CustomerSignUpDraft) o;
    return Objects.equals(email, that.email) &&
        Objects.equals(password, that.password) &&
        Objects.equals(firstName, that.firstName) &&
        Objects.equals(lastName, that.lastName) &&
        Objects.equals(middleName, that.middleName) &&
        Objects.equals(title, that.title) &&
        Objects.equals(dateOfBirth, that.dateOfBirth) &&
        Objects.equals(companyName, that.companyName) &&
        Objects.equals(vatId, that.vatId) &&
        Objects.equals(addresses, that.addresses) &&
        Objects.equals(defaultBillingAddress, that.defaultBillingAddress) &&
        Objects.equals(defaultShippingAddress, that.defaultShippingAddress) &&
        Objects.equals(shippingAddresses, that.shippingAddresses) &&
        Objects.equals(billingAddresses, that.billingAddresses) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(locale, that.locale) &&
        Objects.equals(salutation, that.salutation) &&
        Objects.equals(key, that.key) &&
        Objects.equals(stores, that.stores) &&
        Objects.equals(customerNumber, that.customerNumber) &&
        Objects.equals(anonymousCartId, that.anonymousCartId) &&
        Objects.equals(anonymousCart, that.anonymousCart) &&
        Objects.equals(externalId, that.externalId) &&
        Objects.equals(customerGroup, that.customerGroup) &&
        Objects.equals(customerGroupAssignments, that.customerGroupAssignments) &&
        Objects.equals(isEmailVerified, that.isEmailVerified) &&
        Objects.equals(anonymousId, that.anonymousId) &&
        Objects.equals(authenticationMode, that.authenticationMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(email, password, firstName, lastName, middleName, title, dateOfBirth, companyName, vatId, addresses, defaultBillingAddress, defaultShippingAddress, shippingAddresses, billingAddresses, custom, locale, salutation, key, stores, customerNumber, anonymousCartId, anonymousCart, externalId, customerGroup, customerGroupAssignments, isEmailVerified, anonymousId, authenticationMode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String email;

    private String password;

    private String firstName;

    private String lastName;

    private String middleName;

    private String title;

    private LocalDate dateOfBirth;

    private String companyName;

    private String vatId;

    private List<AddressInput> addresses = Collections.emptyList();

    /**
     * The index of the address in the `addresses` list. The `defaultBillingAddressId` of the customer will be set to the ID of that address.
     */
    private Integer defaultBillingAddress;

    /**
     * The index of the address in the `addresses` list. The `defaultShippingAddressId` of the customer will be set to the ID of that address.
     */
    private Integer defaultShippingAddress;

    /**
     * The indices of the shipping addresses in the `addresses` list. The `shippingAddressIds` of the `Customer` will be set to the IDs of that addresses.
     */
    private List<Integer> shippingAddresses = Collections.emptyList();

    /**
     * The indices of the billing addresses in the `addresses` list. The `billingAddressIds` of the customer will be set to the IDs of that addresses.
     */
    private List<Integer> billingAddresses = Collections.emptyList();

    private CustomFieldsDraft custom;

    private String locale;

    private String salutation;

    private String key;

    private List<ResourceIdentifierInput> stores;

    private String customerNumber;

    /**
     * This field will be deprecated in favour of anonymousCart.id.
     */
    private String anonymousCartId;

    private ResourceIdentifierInput anonymousCart;

    private String externalId;

    private ResourceIdentifierInput customerGroup;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private List<CustomerGroupAssignmentDraft> customerGroupAssignments;

    private Boolean isEmailVerified;

    private String anonymousId;

    private AuthenticationMode authenticationMode;

    public CustomerSignUpDraft build() {
      CustomerSignUpDraft result = new CustomerSignUpDraft();
      result.email = this.email;
      result.password = this.password;
      result.firstName = this.firstName;
      result.lastName = this.lastName;
      result.middleName = this.middleName;
      result.title = this.title;
      result.dateOfBirth = this.dateOfBirth;
      result.companyName = this.companyName;
      result.vatId = this.vatId;
      result.addresses = this.addresses;
      result.defaultBillingAddress = this.defaultBillingAddress;
      result.defaultShippingAddress = this.defaultShippingAddress;
      result.shippingAddresses = this.shippingAddresses;
      result.billingAddresses = this.billingAddresses;
      result.custom = this.custom;
      result.locale = this.locale;
      result.salutation = this.salutation;
      result.key = this.key;
      result.stores = this.stores;
      result.customerNumber = this.customerNumber;
      result.anonymousCartId = this.anonymousCartId;
      result.anonymousCart = this.anonymousCart;
      result.externalId = this.externalId;
      result.customerGroup = this.customerGroup;
      result.customerGroupAssignments = this.customerGroupAssignments;
      result.isEmailVerified = this.isEmailVerified;
      result.anonymousId = this.anonymousId;
      result.authenticationMode = this.authenticationMode;
      return result;
    }

    public Builder email(String email) {
      this.email = email;
      return this;
    }

    public Builder password(String password) {
      this.password = password;
      return this;
    }

    public Builder firstName(String firstName) {
      this.firstName = firstName;
      return this;
    }

    public Builder lastName(String lastName) {
      this.lastName = lastName;
      return this;
    }

    public Builder middleName(String middleName) {
      this.middleName = middleName;
      return this;
    }

    public Builder title(String title) {
      this.title = title;
      return this;
    }

    public Builder dateOfBirth(LocalDate dateOfBirth) {
      this.dateOfBirth = dateOfBirth;
      return this;
    }

    public Builder companyName(String companyName) {
      this.companyName = companyName;
      return this;
    }

    public Builder vatId(String vatId) {
      this.vatId = vatId;
      return this;
    }

    public Builder addresses(List<AddressInput> addresses) {
      this.addresses = addresses;
      return this;
    }

    /**
     * The index of the address in the `addresses` list. The `defaultBillingAddressId` of the customer will be set to the ID of that address.
     */
    public Builder defaultBillingAddress(Integer defaultBillingAddress) {
      this.defaultBillingAddress = defaultBillingAddress;
      return this;
    }

    /**
     * The index of the address in the `addresses` list. The `defaultShippingAddressId` of the customer will be set to the ID of that address.
     */
    public Builder defaultShippingAddress(Integer defaultShippingAddress) {
      this.defaultShippingAddress = defaultShippingAddress;
      return this;
    }

    /**
     * The indices of the shipping addresses in the `addresses` list. The `shippingAddressIds` of the `Customer` will be set to the IDs of that addresses.
     */
    public Builder shippingAddresses(List<Integer> shippingAddresses) {
      this.shippingAddresses = shippingAddresses;
      return this;
    }

    /**
     * The indices of the billing addresses in the `addresses` list. The `billingAddressIds` of the customer will be set to the IDs of that addresses.
     */
    public Builder billingAddresses(List<Integer> billingAddresses) {
      this.billingAddresses = billingAddresses;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder locale(String locale) {
      this.locale = locale;
      return this;
    }

    public Builder salutation(String salutation) {
      this.salutation = salutation;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder stores(List<ResourceIdentifierInput> stores) {
      this.stores = stores;
      return this;
    }

    public Builder customerNumber(String customerNumber) {
      this.customerNumber = customerNumber;
      return this;
    }

    /**
     * This field will be deprecated in favour of anonymousCart.id.
     */
    public Builder anonymousCartId(String anonymousCartId) {
      this.anonymousCartId = anonymousCartId;
      return this;
    }

    public Builder anonymousCart(ResourceIdentifierInput anonymousCart) {
      this.anonymousCart = anonymousCart;
      return this;
    }

    public Builder externalId(String externalId) {
      this.externalId = externalId;
      return this;
    }

    public Builder customerGroup(ResourceIdentifierInput customerGroup) {
      this.customerGroup = customerGroup;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder customerGroupAssignments(
        List<CustomerGroupAssignmentDraft> customerGroupAssignments) {
      this.customerGroupAssignments = customerGroupAssignments;
      return this;
    }

    public Builder isEmailVerified(Boolean isEmailVerified) {
      this.isEmailVerified = isEmailVerified;
      return this;
    }

    public Builder anonymousId(String anonymousId) {
      this.anonymousId = anonymousId;
      return this;
    }

    public Builder authenticationMode(AuthenticationMode authenticationMode) {
      this.authenticationMode = authenticationMode;
      return this;
    }
  }
}
