package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CustomerTitleSet implements com.commercetools.graphql.api.types.MessagePayload {
  private String title;

  private String type;

  public CustomerTitleSet() {
  }

  public CustomerTitleSet(String title, String type) {
    this.title = title;
    this.type = type;
  }

  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "CustomerTitleSet{title='" + title + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerTitleSet that = (CustomerTitleSet) o;
    return Objects.equals(title, that.title) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(title, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String title;

    private String type;

    public CustomerTitleSet build() {
      CustomerTitleSet result = new CustomerTitleSet();
      result.title = this.title;
      result.type = this.type;
      return result;
    }

    public Builder title(String title) {
      this.title = title;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
