package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class CustomerUpdateAction {
  private AddCustomerAddress addAddress;

  private AddCustomerBillingAddressId addBillingAddressId;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private AddCustomerGroupAssignment addCustomerGroupAssignment;

  private AddCustomerShippingAddressId addShippingAddressId;

  private AddCustomerStore addStore;

  private ChangeCustomerAddress changeAddress;

  private ChangeCustomerEmail changeEmail;

  private RemoveCustomerAddress removeAddress;

  private RemoveCustomerBillingAddressId removeBillingAddressId;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private RemoveCustomerGroupAssignment removeCustomerGroupAssignment;

  private RemoveCustomerShippingAddressId removeShippingAddressId;

  private RemoveCustomerStore removeStore;

  private SetCustomerCompanyName setCompanyName;

  private SetCustomerAddressCustomField setAddressCustomField;

  private SetCustomerAddressCustomType setAddressCustomType;

  private SetCustomerAuthenticationMode setAuthenticationMode;

  private SetCustomerCustomField setCustomField;

  private SetCustomerCustomType setCustomType;

  private SetCustomerGroup setCustomerGroup;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private SetCustomerGroupAssignments setCustomerGroupAssignments;

  private SetCustomerKey setKey;

  private SetCustomerLocale setLocale;

  private SetCustomerNumber setCustomerNumber;

  private SetCustomerDateOfBirth setDateOfBirth;

  private SetCustomerDefaultBillingAddress setDefaultBillingAddress;

  private SetCustomerDefaultShippingAddress setDefaultShippingAddress;

  private SetCustomerExternalId setExternalId;

  private SetCustomerFirstName setFirstName;

  private SetCustomerLastName setLastName;

  private SetCustomerMiddleName setMiddleName;

  private SetCustomerSalutation setSalutation;

  private SetCustomerStores setStores;

  private SetCustomerTitle setTitle;

  private SetCustomerVatId setVatId;

  public CustomerUpdateAction() {
  }

  public CustomerUpdateAction(AddCustomerAddress addAddress,
      AddCustomerBillingAddressId addBillingAddressId,
      AddCustomerGroupAssignment addCustomerGroupAssignment,
      AddCustomerShippingAddressId addShippingAddressId, AddCustomerStore addStore,
      ChangeCustomerAddress changeAddress, ChangeCustomerEmail changeEmail,
      RemoveCustomerAddress removeAddress, RemoveCustomerBillingAddressId removeBillingAddressId,
      RemoveCustomerGroupAssignment removeCustomerGroupAssignment,
      RemoveCustomerShippingAddressId removeShippingAddressId, RemoveCustomerStore removeStore,
      SetCustomerCompanyName setCompanyName, SetCustomerAddressCustomField setAddressCustomField,
      SetCustomerAddressCustomType setAddressCustomType,
      SetCustomerAuthenticationMode setAuthenticationMode, SetCustomerCustomField setCustomField,
      SetCustomerCustomType setCustomType, SetCustomerGroup setCustomerGroup,
      SetCustomerGroupAssignments setCustomerGroupAssignments, SetCustomerKey setKey,
      SetCustomerLocale setLocale, SetCustomerNumber setCustomerNumber,
      SetCustomerDateOfBirth setDateOfBirth,
      SetCustomerDefaultBillingAddress setDefaultBillingAddress,
      SetCustomerDefaultShippingAddress setDefaultShippingAddress,
      SetCustomerExternalId setExternalId, SetCustomerFirstName setFirstName,
      SetCustomerLastName setLastName, SetCustomerMiddleName setMiddleName,
      SetCustomerSalutation setSalutation, SetCustomerStores setStores, SetCustomerTitle setTitle,
      SetCustomerVatId setVatId) {
    this.addAddress = addAddress;
    this.addBillingAddressId = addBillingAddressId;
    this.addCustomerGroupAssignment = addCustomerGroupAssignment;
    this.addShippingAddressId = addShippingAddressId;
    this.addStore = addStore;
    this.changeAddress = changeAddress;
    this.changeEmail = changeEmail;
    this.removeAddress = removeAddress;
    this.removeBillingAddressId = removeBillingAddressId;
    this.removeCustomerGroupAssignment = removeCustomerGroupAssignment;
    this.removeShippingAddressId = removeShippingAddressId;
    this.removeStore = removeStore;
    this.setCompanyName = setCompanyName;
    this.setAddressCustomField = setAddressCustomField;
    this.setAddressCustomType = setAddressCustomType;
    this.setAuthenticationMode = setAuthenticationMode;
    this.setCustomField = setCustomField;
    this.setCustomType = setCustomType;
    this.setCustomerGroup = setCustomerGroup;
    this.setCustomerGroupAssignments = setCustomerGroupAssignments;
    this.setKey = setKey;
    this.setLocale = setLocale;
    this.setCustomerNumber = setCustomerNumber;
    this.setDateOfBirth = setDateOfBirth;
    this.setDefaultBillingAddress = setDefaultBillingAddress;
    this.setDefaultShippingAddress = setDefaultShippingAddress;
    this.setExternalId = setExternalId;
    this.setFirstName = setFirstName;
    this.setLastName = setLastName;
    this.setMiddleName = setMiddleName;
    this.setSalutation = setSalutation;
    this.setStores = setStores;
    this.setTitle = setTitle;
    this.setVatId = setVatId;
  }

  public AddCustomerAddress getAddAddress() {
    return addAddress;
  }

  public void setAddAddress(AddCustomerAddress addAddress) {
    this.addAddress = addAddress;
  }

  public AddCustomerBillingAddressId getAddBillingAddressId() {
    return addBillingAddressId;
  }

  public void setAddBillingAddressId(AddCustomerBillingAddressId addBillingAddressId) {
    this.addBillingAddressId = addBillingAddressId;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public AddCustomerGroupAssignment getAddCustomerGroupAssignment() {
    return addCustomerGroupAssignment;
  }

  public void setAddCustomerGroupAssignment(AddCustomerGroupAssignment addCustomerGroupAssignment) {
    this.addCustomerGroupAssignment = addCustomerGroupAssignment;
  }

  public AddCustomerShippingAddressId getAddShippingAddressId() {
    return addShippingAddressId;
  }

  public void setAddShippingAddressId(AddCustomerShippingAddressId addShippingAddressId) {
    this.addShippingAddressId = addShippingAddressId;
  }

  public AddCustomerStore getAddStore() {
    return addStore;
  }

  public void setAddStore(AddCustomerStore addStore) {
    this.addStore = addStore;
  }

  public ChangeCustomerAddress getChangeAddress() {
    return changeAddress;
  }

  public void setChangeAddress(ChangeCustomerAddress changeAddress) {
    this.changeAddress = changeAddress;
  }

  public ChangeCustomerEmail getChangeEmail() {
    return changeEmail;
  }

  public void setChangeEmail(ChangeCustomerEmail changeEmail) {
    this.changeEmail = changeEmail;
  }

  public RemoveCustomerAddress getRemoveAddress() {
    return removeAddress;
  }

  public void setRemoveAddress(RemoveCustomerAddress removeAddress) {
    this.removeAddress = removeAddress;
  }

  public RemoveCustomerBillingAddressId getRemoveBillingAddressId() {
    return removeBillingAddressId;
  }

  public void setRemoveBillingAddressId(RemoveCustomerBillingAddressId removeBillingAddressId) {
    this.removeBillingAddressId = removeBillingAddressId;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public RemoveCustomerGroupAssignment getRemoveCustomerGroupAssignment() {
    return removeCustomerGroupAssignment;
  }

  public void setRemoveCustomerGroupAssignment(
      RemoveCustomerGroupAssignment removeCustomerGroupAssignment) {
    this.removeCustomerGroupAssignment = removeCustomerGroupAssignment;
  }

  public RemoveCustomerShippingAddressId getRemoveShippingAddressId() {
    return removeShippingAddressId;
  }

  public void setRemoveShippingAddressId(RemoveCustomerShippingAddressId removeShippingAddressId) {
    this.removeShippingAddressId = removeShippingAddressId;
  }

  public RemoveCustomerStore getRemoveStore() {
    return removeStore;
  }

  public void setRemoveStore(RemoveCustomerStore removeStore) {
    this.removeStore = removeStore;
  }

  public SetCustomerCompanyName getSetCompanyName() {
    return setCompanyName;
  }

  public void setSetCompanyName(SetCustomerCompanyName setCompanyName) {
    this.setCompanyName = setCompanyName;
  }

  public SetCustomerAddressCustomField getSetAddressCustomField() {
    return setAddressCustomField;
  }

  public void setSetAddressCustomField(SetCustomerAddressCustomField setAddressCustomField) {
    this.setAddressCustomField = setAddressCustomField;
  }

  public SetCustomerAddressCustomType getSetAddressCustomType() {
    return setAddressCustomType;
  }

  public void setSetAddressCustomType(SetCustomerAddressCustomType setAddressCustomType) {
    this.setAddressCustomType = setAddressCustomType;
  }

  public SetCustomerAuthenticationMode getSetAuthenticationMode() {
    return setAuthenticationMode;
  }

  public void setSetAuthenticationMode(SetCustomerAuthenticationMode setAuthenticationMode) {
    this.setAuthenticationMode = setAuthenticationMode;
  }

  public SetCustomerCustomField getSetCustomField() {
    return setCustomField;
  }

  public void setSetCustomField(SetCustomerCustomField setCustomField) {
    this.setCustomField = setCustomField;
  }

  public SetCustomerCustomType getSetCustomType() {
    return setCustomType;
  }

  public void setSetCustomType(SetCustomerCustomType setCustomType) {
    this.setCustomType = setCustomType;
  }

  public SetCustomerGroup getSetCustomerGroup() {
    return setCustomerGroup;
  }

  public void setSetCustomerGroup(SetCustomerGroup setCustomerGroup) {
    this.setCustomerGroup = setCustomerGroup;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public SetCustomerGroupAssignments getSetCustomerGroupAssignments() {
    return setCustomerGroupAssignments;
  }

  public void setSetCustomerGroupAssignments(
      SetCustomerGroupAssignments setCustomerGroupAssignments) {
    this.setCustomerGroupAssignments = setCustomerGroupAssignments;
  }

  public SetCustomerKey getSetKey() {
    return setKey;
  }

  public void setSetKey(SetCustomerKey setKey) {
    this.setKey = setKey;
  }

  public SetCustomerLocale getSetLocale() {
    return setLocale;
  }

  public void setSetLocale(SetCustomerLocale setLocale) {
    this.setLocale = setLocale;
  }

  public SetCustomerNumber getSetCustomerNumber() {
    return setCustomerNumber;
  }

  public void setSetCustomerNumber(SetCustomerNumber setCustomerNumber) {
    this.setCustomerNumber = setCustomerNumber;
  }

  public SetCustomerDateOfBirth getSetDateOfBirth() {
    return setDateOfBirth;
  }

  public void setSetDateOfBirth(SetCustomerDateOfBirth setDateOfBirth) {
    this.setDateOfBirth = setDateOfBirth;
  }

  public SetCustomerDefaultBillingAddress getSetDefaultBillingAddress() {
    return setDefaultBillingAddress;
  }

  public void setSetDefaultBillingAddress(
      SetCustomerDefaultBillingAddress setDefaultBillingAddress) {
    this.setDefaultBillingAddress = setDefaultBillingAddress;
  }

  public SetCustomerDefaultShippingAddress getSetDefaultShippingAddress() {
    return setDefaultShippingAddress;
  }

  public void setSetDefaultShippingAddress(
      SetCustomerDefaultShippingAddress setDefaultShippingAddress) {
    this.setDefaultShippingAddress = setDefaultShippingAddress;
  }

  public SetCustomerExternalId getSetExternalId() {
    return setExternalId;
  }

  public void setSetExternalId(SetCustomerExternalId setExternalId) {
    this.setExternalId = setExternalId;
  }

  public SetCustomerFirstName getSetFirstName() {
    return setFirstName;
  }

  public void setSetFirstName(SetCustomerFirstName setFirstName) {
    this.setFirstName = setFirstName;
  }

  public SetCustomerLastName getSetLastName() {
    return setLastName;
  }

  public void setSetLastName(SetCustomerLastName setLastName) {
    this.setLastName = setLastName;
  }

  public SetCustomerMiddleName getSetMiddleName() {
    return setMiddleName;
  }

  public void setSetMiddleName(SetCustomerMiddleName setMiddleName) {
    this.setMiddleName = setMiddleName;
  }

  public SetCustomerSalutation getSetSalutation() {
    return setSalutation;
  }

  public void setSetSalutation(SetCustomerSalutation setSalutation) {
    this.setSalutation = setSalutation;
  }

  public SetCustomerStores getSetStores() {
    return setStores;
  }

  public void setSetStores(SetCustomerStores setStores) {
    this.setStores = setStores;
  }

  public SetCustomerTitle getSetTitle() {
    return setTitle;
  }

  public void setSetTitle(SetCustomerTitle setTitle) {
    this.setTitle = setTitle;
  }

  public SetCustomerVatId getSetVatId() {
    return setVatId;
  }

  public void setSetVatId(SetCustomerVatId setVatId) {
    this.setVatId = setVatId;
  }

  @Override
  public String toString() {
    return "CustomerUpdateAction{addAddress='" + addAddress + "', addBillingAddressId='" + addBillingAddressId + "', addCustomerGroupAssignment='" + addCustomerGroupAssignment + "', addShippingAddressId='" + addShippingAddressId + "', addStore='" + addStore + "', changeAddress='" + changeAddress + "', changeEmail='" + changeEmail + "', removeAddress='" + removeAddress + "', removeBillingAddressId='" + removeBillingAddressId + "', removeCustomerGroupAssignment='" + removeCustomerGroupAssignment + "', removeShippingAddressId='" + removeShippingAddressId + "', removeStore='" + removeStore + "', setCompanyName='" + setCompanyName + "', setAddressCustomField='" + setAddressCustomField + "', setAddressCustomType='" + setAddressCustomType + "', setAuthenticationMode='" + setAuthenticationMode + "', setCustomField='" + setCustomField + "', setCustomType='" + setCustomType + "', setCustomerGroup='" + setCustomerGroup + "', setCustomerGroupAssignments='" + setCustomerGroupAssignments + "', setKey='" + setKey + "', setLocale='" + setLocale + "', setCustomerNumber='" + setCustomerNumber + "', setDateOfBirth='" + setDateOfBirth + "', setDefaultBillingAddress='" + setDefaultBillingAddress + "', setDefaultShippingAddress='" + setDefaultShippingAddress + "', setExternalId='" + setExternalId + "', setFirstName='" + setFirstName + "', setLastName='" + setLastName + "', setMiddleName='" + setMiddleName + "', setSalutation='" + setSalutation + "', setStores='" + setStores + "', setTitle='" + setTitle + "', setVatId='" + setVatId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerUpdateAction that = (CustomerUpdateAction) o;
    return Objects.equals(addAddress, that.addAddress) &&
        Objects.equals(addBillingAddressId, that.addBillingAddressId) &&
        Objects.equals(addCustomerGroupAssignment, that.addCustomerGroupAssignment) &&
        Objects.equals(addShippingAddressId, that.addShippingAddressId) &&
        Objects.equals(addStore, that.addStore) &&
        Objects.equals(changeAddress, that.changeAddress) &&
        Objects.equals(changeEmail, that.changeEmail) &&
        Objects.equals(removeAddress, that.removeAddress) &&
        Objects.equals(removeBillingAddressId, that.removeBillingAddressId) &&
        Objects.equals(removeCustomerGroupAssignment, that.removeCustomerGroupAssignment) &&
        Objects.equals(removeShippingAddressId, that.removeShippingAddressId) &&
        Objects.equals(removeStore, that.removeStore) &&
        Objects.equals(setCompanyName, that.setCompanyName) &&
        Objects.equals(setAddressCustomField, that.setAddressCustomField) &&
        Objects.equals(setAddressCustomType, that.setAddressCustomType) &&
        Objects.equals(setAuthenticationMode, that.setAuthenticationMode) &&
        Objects.equals(setCustomField, that.setCustomField) &&
        Objects.equals(setCustomType, that.setCustomType) &&
        Objects.equals(setCustomerGroup, that.setCustomerGroup) &&
        Objects.equals(setCustomerGroupAssignments, that.setCustomerGroupAssignments) &&
        Objects.equals(setKey, that.setKey) &&
        Objects.equals(setLocale, that.setLocale) &&
        Objects.equals(setCustomerNumber, that.setCustomerNumber) &&
        Objects.equals(setDateOfBirth, that.setDateOfBirth) &&
        Objects.equals(setDefaultBillingAddress, that.setDefaultBillingAddress) &&
        Objects.equals(setDefaultShippingAddress, that.setDefaultShippingAddress) &&
        Objects.equals(setExternalId, that.setExternalId) &&
        Objects.equals(setFirstName, that.setFirstName) &&
        Objects.equals(setLastName, that.setLastName) &&
        Objects.equals(setMiddleName, that.setMiddleName) &&
        Objects.equals(setSalutation, that.setSalutation) &&
        Objects.equals(setStores, that.setStores) &&
        Objects.equals(setTitle, that.setTitle) &&
        Objects.equals(setVatId, that.setVatId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addAddress, addBillingAddressId, addCustomerGroupAssignment, addShippingAddressId, addStore, changeAddress, changeEmail, removeAddress, removeBillingAddressId, removeCustomerGroupAssignment, removeShippingAddressId, removeStore, setCompanyName, setAddressCustomField, setAddressCustomType, setAuthenticationMode, setCustomField, setCustomType, setCustomerGroup, setCustomerGroupAssignments, setKey, setLocale, setCustomerNumber, setDateOfBirth, setDefaultBillingAddress, setDefaultShippingAddress, setExternalId, setFirstName, setLastName, setMiddleName, setSalutation, setStores, setTitle, setVatId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AddCustomerAddress addAddress;

    private AddCustomerBillingAddressId addBillingAddressId;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private AddCustomerGroupAssignment addCustomerGroupAssignment;

    private AddCustomerShippingAddressId addShippingAddressId;

    private AddCustomerStore addStore;

    private ChangeCustomerAddress changeAddress;

    private ChangeCustomerEmail changeEmail;

    private RemoveCustomerAddress removeAddress;

    private RemoveCustomerBillingAddressId removeBillingAddressId;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private RemoveCustomerGroupAssignment removeCustomerGroupAssignment;

    private RemoveCustomerShippingAddressId removeShippingAddressId;

    private RemoveCustomerStore removeStore;

    private SetCustomerCompanyName setCompanyName;

    private SetCustomerAddressCustomField setAddressCustomField;

    private SetCustomerAddressCustomType setAddressCustomType;

    private SetCustomerAuthenticationMode setAuthenticationMode;

    private SetCustomerCustomField setCustomField;

    private SetCustomerCustomType setCustomType;

    private SetCustomerGroup setCustomerGroup;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private SetCustomerGroupAssignments setCustomerGroupAssignments;

    private SetCustomerKey setKey;

    private SetCustomerLocale setLocale;

    private SetCustomerNumber setCustomerNumber;

    private SetCustomerDateOfBirth setDateOfBirth;

    private SetCustomerDefaultBillingAddress setDefaultBillingAddress;

    private SetCustomerDefaultShippingAddress setDefaultShippingAddress;

    private SetCustomerExternalId setExternalId;

    private SetCustomerFirstName setFirstName;

    private SetCustomerLastName setLastName;

    private SetCustomerMiddleName setMiddleName;

    private SetCustomerSalutation setSalutation;

    private SetCustomerStores setStores;

    private SetCustomerTitle setTitle;

    private SetCustomerVatId setVatId;

    public CustomerUpdateAction build() {
      CustomerUpdateAction result = new CustomerUpdateAction();
      result.addAddress = this.addAddress;
      result.addBillingAddressId = this.addBillingAddressId;
      result.addCustomerGroupAssignment = this.addCustomerGroupAssignment;
      result.addShippingAddressId = this.addShippingAddressId;
      result.addStore = this.addStore;
      result.changeAddress = this.changeAddress;
      result.changeEmail = this.changeEmail;
      result.removeAddress = this.removeAddress;
      result.removeBillingAddressId = this.removeBillingAddressId;
      result.removeCustomerGroupAssignment = this.removeCustomerGroupAssignment;
      result.removeShippingAddressId = this.removeShippingAddressId;
      result.removeStore = this.removeStore;
      result.setCompanyName = this.setCompanyName;
      result.setAddressCustomField = this.setAddressCustomField;
      result.setAddressCustomType = this.setAddressCustomType;
      result.setAuthenticationMode = this.setAuthenticationMode;
      result.setCustomField = this.setCustomField;
      result.setCustomType = this.setCustomType;
      result.setCustomerGroup = this.setCustomerGroup;
      result.setCustomerGroupAssignments = this.setCustomerGroupAssignments;
      result.setKey = this.setKey;
      result.setLocale = this.setLocale;
      result.setCustomerNumber = this.setCustomerNumber;
      result.setDateOfBirth = this.setDateOfBirth;
      result.setDefaultBillingAddress = this.setDefaultBillingAddress;
      result.setDefaultShippingAddress = this.setDefaultShippingAddress;
      result.setExternalId = this.setExternalId;
      result.setFirstName = this.setFirstName;
      result.setLastName = this.setLastName;
      result.setMiddleName = this.setMiddleName;
      result.setSalutation = this.setSalutation;
      result.setStores = this.setStores;
      result.setTitle = this.setTitle;
      result.setVatId = this.setVatId;
      return result;
    }

    public Builder addAddress(AddCustomerAddress addAddress) {
      this.addAddress = addAddress;
      return this;
    }

    public Builder addBillingAddressId(AddCustomerBillingAddressId addBillingAddressId) {
      this.addBillingAddressId = addBillingAddressId;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder addCustomerGroupAssignment(
        AddCustomerGroupAssignment addCustomerGroupAssignment) {
      this.addCustomerGroupAssignment = addCustomerGroupAssignment;
      return this;
    }

    public Builder addShippingAddressId(AddCustomerShippingAddressId addShippingAddressId) {
      this.addShippingAddressId = addShippingAddressId;
      return this;
    }

    public Builder addStore(AddCustomerStore addStore) {
      this.addStore = addStore;
      return this;
    }

    public Builder changeAddress(ChangeCustomerAddress changeAddress) {
      this.changeAddress = changeAddress;
      return this;
    }

    public Builder changeEmail(ChangeCustomerEmail changeEmail) {
      this.changeEmail = changeEmail;
      return this;
    }

    public Builder removeAddress(RemoveCustomerAddress removeAddress) {
      this.removeAddress = removeAddress;
      return this;
    }

    public Builder removeBillingAddressId(RemoveCustomerBillingAddressId removeBillingAddressId) {
      this.removeBillingAddressId = removeBillingAddressId;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder removeCustomerGroupAssignment(
        RemoveCustomerGroupAssignment removeCustomerGroupAssignment) {
      this.removeCustomerGroupAssignment = removeCustomerGroupAssignment;
      return this;
    }

    public Builder removeShippingAddressId(
        RemoveCustomerShippingAddressId removeShippingAddressId) {
      this.removeShippingAddressId = removeShippingAddressId;
      return this;
    }

    public Builder removeStore(RemoveCustomerStore removeStore) {
      this.removeStore = removeStore;
      return this;
    }

    public Builder setCompanyName(SetCustomerCompanyName setCompanyName) {
      this.setCompanyName = setCompanyName;
      return this;
    }

    public Builder setAddressCustomField(SetCustomerAddressCustomField setAddressCustomField) {
      this.setAddressCustomField = setAddressCustomField;
      return this;
    }

    public Builder setAddressCustomType(SetCustomerAddressCustomType setAddressCustomType) {
      this.setAddressCustomType = setAddressCustomType;
      return this;
    }

    public Builder setAuthenticationMode(SetCustomerAuthenticationMode setAuthenticationMode) {
      this.setAuthenticationMode = setAuthenticationMode;
      return this;
    }

    public Builder setCustomField(SetCustomerCustomField setCustomField) {
      this.setCustomField = setCustomField;
      return this;
    }

    public Builder setCustomType(SetCustomerCustomType setCustomType) {
      this.setCustomType = setCustomType;
      return this;
    }

    public Builder setCustomerGroup(SetCustomerGroup setCustomerGroup) {
      this.setCustomerGroup = setCustomerGroup;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder setCustomerGroupAssignments(
        SetCustomerGroupAssignments setCustomerGroupAssignments) {
      this.setCustomerGroupAssignments = setCustomerGroupAssignments;
      return this;
    }

    public Builder setKey(SetCustomerKey setKey) {
      this.setKey = setKey;
      return this;
    }

    public Builder setLocale(SetCustomerLocale setLocale) {
      this.setLocale = setLocale;
      return this;
    }

    public Builder setCustomerNumber(SetCustomerNumber setCustomerNumber) {
      this.setCustomerNumber = setCustomerNumber;
      return this;
    }

    public Builder setDateOfBirth(SetCustomerDateOfBirth setDateOfBirth) {
      this.setDateOfBirth = setDateOfBirth;
      return this;
    }

    public Builder setDefaultBillingAddress(
        SetCustomerDefaultBillingAddress setDefaultBillingAddress) {
      this.setDefaultBillingAddress = setDefaultBillingAddress;
      return this;
    }

    public Builder setDefaultShippingAddress(
        SetCustomerDefaultShippingAddress setDefaultShippingAddress) {
      this.setDefaultShippingAddress = setDefaultShippingAddress;
      return this;
    }

    public Builder setExternalId(SetCustomerExternalId setExternalId) {
      this.setExternalId = setExternalId;
      return this;
    }

    public Builder setFirstName(SetCustomerFirstName setFirstName) {
      this.setFirstName = setFirstName;
      return this;
    }

    public Builder setLastName(SetCustomerLastName setLastName) {
      this.setLastName = setLastName;
      return this;
    }

    public Builder setMiddleName(SetCustomerMiddleName setMiddleName) {
      this.setMiddleName = setMiddleName;
      return this;
    }

    public Builder setSalutation(SetCustomerSalutation setSalutation) {
      this.setSalutation = setSalutation;
      return this;
    }

    public Builder setStores(SetCustomerStores setStores) {
      this.setStores = setStores;
      return this;
    }

    public Builder setTitle(SetCustomerTitle setTitle) {
      this.setTitle = setTitle;
      return this;
    }

    public Builder setVatId(SetCustomerVatId setVatId) {
      this.setVatId = setVatId;
      return this;
    }
  }
}
