package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class DeliveryItemDraftType {
  private String id;

  private Long quantity;

  public DeliveryItemDraftType() {
  }

  public DeliveryItemDraftType(String id, Long quantity) {
    this.id = id;
    this.quantity = quantity;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  @Override
  public String toString() {
    return "DeliveryItemDraftType{id='" + id + "', quantity='" + quantity + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DeliveryItemDraftType that = (DeliveryItemDraftType) o;
    return Objects.equals(id, that.id) &&
        Objects.equals(quantity, that.quantity);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, quantity);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String id;

    private Long quantity;

    public DeliveryItemDraftType build() {
      DeliveryItemDraftType result = new DeliveryItemDraftType();
      result.id = this.id;
      result.quantity = this.quantity;
      return result;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }
  }
}
