package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class DeliveryItemsUpdated implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private String deliveryId;

  private List<DeliveryItem> items;

  private List<DeliveryItem> oldItems;

  private String shippingKey;

  private String type;

  public DeliveryItemsUpdated() {
  }

  public DeliveryItemsUpdated(String deliveryId, List<DeliveryItem> items,
      List<DeliveryItem> oldItems, String shippingKey, String type) {
    this.deliveryId = deliveryId;
    this.items = items;
    this.oldItems = oldItems;
    this.shippingKey = shippingKey;
    this.type = type;
  }

  public String getDeliveryId() {
    return deliveryId;
  }

  public void setDeliveryId(String deliveryId) {
    this.deliveryId = deliveryId;
  }

  public List<DeliveryItem> getItems() {
    return items;
  }

  public void setItems(List<DeliveryItem> items) {
    this.items = items;
  }

  public List<DeliveryItem> getOldItems() {
    return oldItems;
  }

  public void setOldItems(List<DeliveryItem> oldItems) {
    this.oldItems = oldItems;
  }

  public String getShippingKey() {
    return shippingKey;
  }

  public void setShippingKey(String shippingKey) {
    this.shippingKey = shippingKey;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "DeliveryItemsUpdated{deliveryId='" + deliveryId + "', items='" + items + "', oldItems='" + oldItems + "', shippingKey='" + shippingKey + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DeliveryItemsUpdated that = (DeliveryItemsUpdated) o;
    return Objects.equals(deliveryId, that.deliveryId) &&
        Objects.equals(items, that.items) &&
        Objects.equals(oldItems, that.oldItems) &&
        Objects.equals(shippingKey, that.shippingKey) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deliveryId, items, oldItems, shippingKey, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String deliveryId;

    private List<DeliveryItem> items;

    private List<DeliveryItem> oldItems;

    private String shippingKey;

    private String type;

    public DeliveryItemsUpdated build() {
      DeliveryItemsUpdated result = new DeliveryItemsUpdated();
      result.deliveryId = this.deliveryId;
      result.items = this.items;
      result.oldItems = this.oldItems;
      result.shippingKey = this.shippingKey;
      result.type = this.type;
      return result;
    }

    public Builder deliveryId(String deliveryId) {
      this.deliveryId = deliveryId;
      return this;
    }

    public Builder items(List<DeliveryItem> items) {
      this.items = items;
      return this;
    }

    public Builder oldItems(List<DeliveryItem> oldItems) {
      this.oldItems = oldItems;
      return this;
    }

    public Builder shippingKey(String shippingKey) {
      this.shippingKey = shippingKey;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
