package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class DirectDiscountDraft {
  private CartDiscountValueInput value;

  private CartDiscountTargetInput target;

  public DirectDiscountDraft() {
  }

  public DirectDiscountDraft(CartDiscountValueInput value, CartDiscountTargetInput target) {
    this.value = value;
    this.target = target;
  }

  public CartDiscountValueInput getValue() {
    return value;
  }

  public void setValue(CartDiscountValueInput value) {
    this.value = value;
  }

  public CartDiscountTargetInput getTarget() {
    return target;
  }

  public void setTarget(CartDiscountTargetInput target) {
    this.target = target;
  }

  @Override
  public String toString() {
    return "DirectDiscountDraft{value='" + value + "', target='" + target + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DirectDiscountDraft that = (DirectDiscountDraft) o;
    return Objects.equals(value, that.value) &&
        Objects.equals(target, that.target);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value, target);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private CartDiscountValueInput value;

    private CartDiscountTargetInput target;

    public DirectDiscountDraft build() {
      DirectDiscountDraft result = new DirectDiscountDraft();
      result.value = this.value;
      result.target = this.target;
      return result;
    }

    public Builder value(CartDiscountValueInput value) {
      this.value = value;
      return this;
    }

    public Builder target(CartDiscountTargetInput target) {
      this.target = target;
      return this;
    }
  }
}
