package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class DirectDiscountDraftOutput {
  private CartDiscountValue value;

  private CartDiscountTarget target;

  public DirectDiscountDraftOutput() {
  }

  public DirectDiscountDraftOutput(CartDiscountValue value, CartDiscountTarget target) {
    this.value = value;
    this.target = target;
  }

  public CartDiscountValue getValue() {
    return value;
  }

  public void setValue(CartDiscountValue value) {
    this.value = value;
  }

  public CartDiscountTarget getTarget() {
    return target;
  }

  public void setTarget(CartDiscountTarget target) {
    this.target = target;
  }

  @Override
  public String toString() {
    return "DirectDiscountDraftOutput{value='" + value + "', target='" + target + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DirectDiscountDraftOutput that = (DirectDiscountDraftOutput) o;
    return Objects.equals(value, that.value) &&
        Objects.equals(target, that.target);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value, target);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private CartDiscountValue value;

    private CartDiscountTarget target;

    public DirectDiscountDraftOutput build() {
      DirectDiscountDraftOutput result = new DirectDiscountDraftOutput();
      result.value = this.value;
      result.target = this.target;
      return result;
    }

    public Builder value(CartDiscountValue value) {
      this.value = value;
      return this;
    }

    public Builder target(CartDiscountTarget target) {
      this.target = target;
      return this;
    }
  }
}
