package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

/**
 * With discount codes it is possible to give specific cart discounts to an eligible amount of users. They are defined by a string value which can be added to a cart so that specific cart discounts can be applied to the cart.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class DiscountCode implements com.commercetools.graphql.api.types.Versioned, com.commercetools.graphql.api.types.ReferenceExpandable {
  private String code;

  private String key;

  private Boolean isActive;

  private Long maxApplications;

  private Long maxApplicationsPerCustomer;

  private String cartPredicate;

  private Long applicationVersion;

  private OffsetDateTime validFrom;

  private OffsetDateTime validUntil;

  private List<String> groups;

  private String name;

  private String description;

  private List<CartDiscount> cartDiscounts;

  private List<Reference> referenceRefs;

  private List<LocalizedString> nameAllLocales;

  private List<LocalizedString> descriptionAllLocales;

  private CustomFieldsType custom;

  /**
   * How many times this discount code was applied (only applications that were part of a successful checkout are considered)
   */
  private Long applicationCount;

  private List<Reference> cartDiscountRefs;

  private String id;

  private Long version;

  private OffsetDateTime createdAt;

  private OffsetDateTime lastModifiedAt;

  private Initiator createdBy;

  private Initiator lastModifiedBy;

  public DiscountCode() {
  }

  public DiscountCode(String code, String key, Boolean isActive, Long maxApplications,
      Long maxApplicationsPerCustomer, String cartPredicate, Long applicationVersion,
      OffsetDateTime validFrom, OffsetDateTime validUntil, List<String> groups, String name,
      String description, List<CartDiscount> cartDiscounts, List<Reference> referenceRefs,
      List<LocalizedString> nameAllLocales, List<LocalizedString> descriptionAllLocales,
      CustomFieldsType custom, Long applicationCount, List<Reference> cartDiscountRefs, String id,
      Long version, OffsetDateTime createdAt, OffsetDateTime lastModifiedAt, Initiator createdBy,
      Initiator lastModifiedBy) {
    this.code = code;
    this.key = key;
    this.isActive = isActive;
    this.maxApplications = maxApplications;
    this.maxApplicationsPerCustomer = maxApplicationsPerCustomer;
    this.cartPredicate = cartPredicate;
    this.applicationVersion = applicationVersion;
    this.validFrom = validFrom;
    this.validUntil = validUntil;
    this.groups = groups;
    this.name = name;
    this.description = description;
    this.cartDiscounts = cartDiscounts;
    this.referenceRefs = referenceRefs;
    this.nameAllLocales = nameAllLocales;
    this.descriptionAllLocales = descriptionAllLocales;
    this.custom = custom;
    this.applicationCount = applicationCount;
    this.cartDiscountRefs = cartDiscountRefs;
    this.id = id;
    this.version = version;
    this.createdAt = createdAt;
    this.lastModifiedAt = lastModifiedAt;
    this.createdBy = createdBy;
    this.lastModifiedBy = lastModifiedBy;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public Boolean getIsActive() {
    return isActive;
  }

  public void setIsActive(Boolean isActive) {
    this.isActive = isActive;
  }

  public Long getMaxApplications() {
    return maxApplications;
  }

  public void setMaxApplications(Long maxApplications) {
    this.maxApplications = maxApplications;
  }

  public Long getMaxApplicationsPerCustomer() {
    return maxApplicationsPerCustomer;
  }

  public void setMaxApplicationsPerCustomer(Long maxApplicationsPerCustomer) {
    this.maxApplicationsPerCustomer = maxApplicationsPerCustomer;
  }

  public String getCartPredicate() {
    return cartPredicate;
  }

  public void setCartPredicate(String cartPredicate) {
    this.cartPredicate = cartPredicate;
  }

  public Long getApplicationVersion() {
    return applicationVersion;
  }

  public void setApplicationVersion(Long applicationVersion) {
    this.applicationVersion = applicationVersion;
  }

  public OffsetDateTime getValidFrom() {
    return validFrom;
  }

  public void setValidFrom(OffsetDateTime validFrom) {
    this.validFrom = validFrom;
  }

  public OffsetDateTime getValidUntil() {
    return validUntil;
  }

  public void setValidUntil(OffsetDateTime validUntil) {
    this.validUntil = validUntil;
  }

  public List<String> getGroups() {
    return groups;
  }

  public void setGroups(List<String> groups) {
    this.groups = groups;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public List<CartDiscount> getCartDiscounts() {
    return cartDiscounts;
  }

  public void setCartDiscounts(List<CartDiscount> cartDiscounts) {
    this.cartDiscounts = cartDiscounts;
  }

  public List<Reference> getReferenceRefs() {
    return referenceRefs;
  }

  public void setReferenceRefs(List<Reference> referenceRefs) {
    this.referenceRefs = referenceRefs;
  }

  public List<LocalizedString> getNameAllLocales() {
    return nameAllLocales;
  }

  public void setNameAllLocales(List<LocalizedString> nameAllLocales) {
    this.nameAllLocales = nameAllLocales;
  }

  public List<LocalizedString> getDescriptionAllLocales() {
    return descriptionAllLocales;
  }

  public void setDescriptionAllLocales(List<LocalizedString> descriptionAllLocales) {
    this.descriptionAllLocales = descriptionAllLocales;
  }

  public CustomFieldsType getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsType custom) {
    this.custom = custom;
  }

  /**
   * How many times this discount code was applied (only applications that were part of a successful checkout are considered)
   */
  public Long getApplicationCount() {
    return applicationCount;
  }

  public void setApplicationCount(Long applicationCount) {
    this.applicationCount = applicationCount;
  }

  public List<Reference> getCartDiscountRefs() {
    return cartDiscountRefs;
  }

  public void setCartDiscountRefs(List<Reference> cartDiscountRefs) {
    this.cartDiscountRefs = cartDiscountRefs;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public Initiator getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(Initiator createdBy) {
    this.createdBy = createdBy;
  }

  public Initiator getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(Initiator lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  @Override
  public String toString() {
    return "DiscountCode{code='" + code + "', key='" + key + "', isActive='" + isActive + "', maxApplications='" + maxApplications + "', maxApplicationsPerCustomer='" + maxApplicationsPerCustomer + "', cartPredicate='" + cartPredicate + "', applicationVersion='" + applicationVersion + "', validFrom='" + validFrom + "', validUntil='" + validUntil + "', groups='" + groups + "', name='" + name + "', description='" + description + "', cartDiscounts='" + cartDiscounts + "', referenceRefs='" + referenceRefs + "', nameAllLocales='" + nameAllLocales + "', descriptionAllLocales='" + descriptionAllLocales + "', custom='" + custom + "', applicationCount='" + applicationCount + "', cartDiscountRefs='" + cartDiscountRefs + "', id='" + id + "', version='" + version + "', createdAt='" + createdAt + "', lastModifiedAt='" + lastModifiedAt + "', createdBy='" + createdBy + "', lastModifiedBy='" + lastModifiedBy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DiscountCode that = (DiscountCode) o;
    return Objects.equals(code, that.code) &&
        Objects.equals(key, that.key) &&
        Objects.equals(isActive, that.isActive) &&
        Objects.equals(maxApplications, that.maxApplications) &&
        Objects.equals(maxApplicationsPerCustomer, that.maxApplicationsPerCustomer) &&
        Objects.equals(cartPredicate, that.cartPredicate) &&
        Objects.equals(applicationVersion, that.applicationVersion) &&
        Objects.equals(validFrom, that.validFrom) &&
        Objects.equals(validUntil, that.validUntil) &&
        Objects.equals(groups, that.groups) &&
        Objects.equals(name, that.name) &&
        Objects.equals(description, that.description) &&
        Objects.equals(cartDiscounts, that.cartDiscounts) &&
        Objects.equals(referenceRefs, that.referenceRefs) &&
        Objects.equals(nameAllLocales, that.nameAllLocales) &&
        Objects.equals(descriptionAllLocales, that.descriptionAllLocales) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(applicationCount, that.applicationCount) &&
        Objects.equals(cartDiscountRefs, that.cartDiscountRefs) &&
        Objects.equals(id, that.id) &&
        Objects.equals(version, that.version) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(createdBy, that.createdBy) &&
        Objects.equals(lastModifiedBy, that.lastModifiedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, key, isActive, maxApplications, maxApplicationsPerCustomer, cartPredicate, applicationVersion, validFrom, validUntil, groups, name, description, cartDiscounts, referenceRefs, nameAllLocales, descriptionAllLocales, custom, applicationCount, cartDiscountRefs, id, version, createdAt, lastModifiedAt, createdBy, lastModifiedBy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String code;

    private String key;

    private Boolean isActive;

    private Long maxApplications;

    private Long maxApplicationsPerCustomer;

    private String cartPredicate;

    private Long applicationVersion;

    private OffsetDateTime validFrom;

    private OffsetDateTime validUntil;

    private List<String> groups;

    private String name;

    private String description;

    private List<CartDiscount> cartDiscounts;

    private List<Reference> referenceRefs;

    private List<LocalizedString> nameAllLocales;

    private List<LocalizedString> descriptionAllLocales;

    private CustomFieldsType custom;

    /**
     * How many times this discount code was applied (only applications that were part of a successful checkout are considered)
     */
    private Long applicationCount;

    private List<Reference> cartDiscountRefs;

    private String id;

    private Long version;

    private OffsetDateTime createdAt;

    private OffsetDateTime lastModifiedAt;

    private Initiator createdBy;

    private Initiator lastModifiedBy;

    public DiscountCode build() {
      DiscountCode result = new DiscountCode();
      result.code = this.code;
      result.key = this.key;
      result.isActive = this.isActive;
      result.maxApplications = this.maxApplications;
      result.maxApplicationsPerCustomer = this.maxApplicationsPerCustomer;
      result.cartPredicate = this.cartPredicate;
      result.applicationVersion = this.applicationVersion;
      result.validFrom = this.validFrom;
      result.validUntil = this.validUntil;
      result.groups = this.groups;
      result.name = this.name;
      result.description = this.description;
      result.cartDiscounts = this.cartDiscounts;
      result.referenceRefs = this.referenceRefs;
      result.nameAllLocales = this.nameAllLocales;
      result.descriptionAllLocales = this.descriptionAllLocales;
      result.custom = this.custom;
      result.applicationCount = this.applicationCount;
      result.cartDiscountRefs = this.cartDiscountRefs;
      result.id = this.id;
      result.version = this.version;
      result.createdAt = this.createdAt;
      result.lastModifiedAt = this.lastModifiedAt;
      result.createdBy = this.createdBy;
      result.lastModifiedBy = this.lastModifiedBy;
      return result;
    }

    public Builder code(String code) {
      this.code = code;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder isActive(Boolean isActive) {
      this.isActive = isActive;
      return this;
    }

    public Builder maxApplications(Long maxApplications) {
      this.maxApplications = maxApplications;
      return this;
    }

    public Builder maxApplicationsPerCustomer(Long maxApplicationsPerCustomer) {
      this.maxApplicationsPerCustomer = maxApplicationsPerCustomer;
      return this;
    }

    public Builder cartPredicate(String cartPredicate) {
      this.cartPredicate = cartPredicate;
      return this;
    }

    public Builder applicationVersion(Long applicationVersion) {
      this.applicationVersion = applicationVersion;
      return this;
    }

    public Builder validFrom(OffsetDateTime validFrom) {
      this.validFrom = validFrom;
      return this;
    }

    public Builder validUntil(OffsetDateTime validUntil) {
      this.validUntil = validUntil;
      return this;
    }

    public Builder groups(List<String> groups) {
      this.groups = groups;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder description(String description) {
      this.description = description;
      return this;
    }

    public Builder cartDiscounts(List<CartDiscount> cartDiscounts) {
      this.cartDiscounts = cartDiscounts;
      return this;
    }

    public Builder referenceRefs(List<Reference> referenceRefs) {
      this.referenceRefs = referenceRefs;
      return this;
    }

    public Builder nameAllLocales(List<LocalizedString> nameAllLocales) {
      this.nameAllLocales = nameAllLocales;
      return this;
    }

    public Builder descriptionAllLocales(List<LocalizedString> descriptionAllLocales) {
      this.descriptionAllLocales = descriptionAllLocales;
      return this;
    }

    public Builder custom(CustomFieldsType custom) {
      this.custom = custom;
      return this;
    }

    /**
     * How many times this discount code was applied (only applications that were part of a successful checkout are considered)
     */
    public Builder applicationCount(Long applicationCount) {
      this.applicationCount = applicationCount;
      return this;
    }

    public Builder cartDiscountRefs(List<Reference> cartDiscountRefs) {
      this.cartDiscountRefs = cartDiscountRefs;
      return this;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder createdBy(Initiator createdBy) {
      this.createdBy = createdBy;
      return this;
    }

    public Builder lastModifiedBy(Initiator lastModifiedBy) {
      this.lastModifiedBy = lastModifiedBy;
      return this;
    }
  }
}
