package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class DiscountCodeInfo {
  private Reference discountCodeRef;

  private DiscountCodeState state;

  private DiscountCode discountCode;

  public DiscountCodeInfo() {
  }

  public DiscountCodeInfo(Reference discountCodeRef, DiscountCodeState state,
      DiscountCode discountCode) {
    this.discountCodeRef = discountCodeRef;
    this.state = state;
    this.discountCode = discountCode;
  }

  public Reference getDiscountCodeRef() {
    return discountCodeRef;
  }

  public void setDiscountCodeRef(Reference discountCodeRef) {
    this.discountCodeRef = discountCodeRef;
  }

  public DiscountCodeState getState() {
    return state;
  }

  public void setState(DiscountCodeState state) {
    this.state = state;
  }

  public DiscountCode getDiscountCode() {
    return discountCode;
  }

  public void setDiscountCode(DiscountCode discountCode) {
    this.discountCode = discountCode;
  }

  @Override
  public String toString() {
    return "DiscountCodeInfo{discountCodeRef='" + discountCodeRef + "', state='" + state + "', discountCode='" + discountCode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DiscountCodeInfo that = (DiscountCodeInfo) o;
    return Objects.equals(discountCodeRef, that.discountCodeRef) &&
        Objects.equals(state, that.state) &&
        Objects.equals(discountCode, that.discountCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(discountCodeRef, state, discountCode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Reference discountCodeRef;

    private DiscountCodeState state;

    private DiscountCode discountCode;

    public DiscountCodeInfo build() {
      DiscountCodeInfo result = new DiscountCodeInfo();
      result.discountCodeRef = this.discountCodeRef;
      result.state = this.state;
      result.discountCode = this.discountCode;
      return result;
    }

    public Builder discountCodeRef(Reference discountCodeRef) {
      this.discountCodeRef = discountCodeRef;
      return this;
    }

    public Builder state(DiscountCodeState state) {
      this.state = state;
      return this;
    }

    public Builder discountCode(DiscountCode discountCode) {
      this.discountCode = discountCode;
      return this;
    }
  }
}
