package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class DiscountCodeUpdateAction {
  private ChangeDiscountCodeCartDiscounts changeCartDiscounts;

  private ChangeDiscountCodeGroups changeGroups;

  private ChangeDiscountCodeIsActive changeIsActive;

  private SetDiscountCodeCartPredicate setCartPredicate;

  private SetDiscountCodeCustomField setCustomField;

  private SetDiscountCodeCustomType setCustomType;

  private SetDiscountCodeDescription setDescription;

  private SetDiscountCodeKey setKey;

  private SetDiscountCodeMaxApplications setMaxApplications;

  private SetDiscountCodeMaxApplicationsPerCustomer setMaxApplicationsPerCustomer;

  private SetDiscountCodeName setName;

  private SetDiscountCodeValidFrom setValidFrom;

  private SetDiscountCodeValidFromAndUntil setValidFromAndUntil;

  private SetDiscountCodeValidUntil setValidUntil;

  public DiscountCodeUpdateAction() {
  }

  public DiscountCodeUpdateAction(ChangeDiscountCodeCartDiscounts changeCartDiscounts,
      ChangeDiscountCodeGroups changeGroups, ChangeDiscountCodeIsActive changeIsActive,
      SetDiscountCodeCartPredicate setCartPredicate, SetDiscountCodeCustomField setCustomField,
      SetDiscountCodeCustomType setCustomType, SetDiscountCodeDescription setDescription,
      SetDiscountCodeKey setKey, SetDiscountCodeMaxApplications setMaxApplications,
      SetDiscountCodeMaxApplicationsPerCustomer setMaxApplicationsPerCustomer,
      SetDiscountCodeName setName, SetDiscountCodeValidFrom setValidFrom,
      SetDiscountCodeValidFromAndUntil setValidFromAndUntil,
      SetDiscountCodeValidUntil setValidUntil) {
    this.changeCartDiscounts = changeCartDiscounts;
    this.changeGroups = changeGroups;
    this.changeIsActive = changeIsActive;
    this.setCartPredicate = setCartPredicate;
    this.setCustomField = setCustomField;
    this.setCustomType = setCustomType;
    this.setDescription = setDescription;
    this.setKey = setKey;
    this.setMaxApplications = setMaxApplications;
    this.setMaxApplicationsPerCustomer = setMaxApplicationsPerCustomer;
    this.setName = setName;
    this.setValidFrom = setValidFrom;
    this.setValidFromAndUntil = setValidFromAndUntil;
    this.setValidUntil = setValidUntil;
  }

  public ChangeDiscountCodeCartDiscounts getChangeCartDiscounts() {
    return changeCartDiscounts;
  }

  public void setChangeCartDiscounts(ChangeDiscountCodeCartDiscounts changeCartDiscounts) {
    this.changeCartDiscounts = changeCartDiscounts;
  }

  public ChangeDiscountCodeGroups getChangeGroups() {
    return changeGroups;
  }

  public void setChangeGroups(ChangeDiscountCodeGroups changeGroups) {
    this.changeGroups = changeGroups;
  }

  public ChangeDiscountCodeIsActive getChangeIsActive() {
    return changeIsActive;
  }

  public void setChangeIsActive(ChangeDiscountCodeIsActive changeIsActive) {
    this.changeIsActive = changeIsActive;
  }

  public SetDiscountCodeCartPredicate getSetCartPredicate() {
    return setCartPredicate;
  }

  public void setSetCartPredicate(SetDiscountCodeCartPredicate setCartPredicate) {
    this.setCartPredicate = setCartPredicate;
  }

  public SetDiscountCodeCustomField getSetCustomField() {
    return setCustomField;
  }

  public void setSetCustomField(SetDiscountCodeCustomField setCustomField) {
    this.setCustomField = setCustomField;
  }

  public SetDiscountCodeCustomType getSetCustomType() {
    return setCustomType;
  }

  public void setSetCustomType(SetDiscountCodeCustomType setCustomType) {
    this.setCustomType = setCustomType;
  }

  public SetDiscountCodeDescription getSetDescription() {
    return setDescription;
  }

  public void setSetDescription(SetDiscountCodeDescription setDescription) {
    this.setDescription = setDescription;
  }

  public SetDiscountCodeKey getSetKey() {
    return setKey;
  }

  public void setSetKey(SetDiscountCodeKey setKey) {
    this.setKey = setKey;
  }

  public SetDiscountCodeMaxApplications getSetMaxApplications() {
    return setMaxApplications;
  }

  public void setSetMaxApplications(SetDiscountCodeMaxApplications setMaxApplications) {
    this.setMaxApplications = setMaxApplications;
  }

  public SetDiscountCodeMaxApplicationsPerCustomer getSetMaxApplicationsPerCustomer() {
    return setMaxApplicationsPerCustomer;
  }

  public void setSetMaxApplicationsPerCustomer(
      SetDiscountCodeMaxApplicationsPerCustomer setMaxApplicationsPerCustomer) {
    this.setMaxApplicationsPerCustomer = setMaxApplicationsPerCustomer;
  }

  public SetDiscountCodeName getSetName() {
    return setName;
  }

  public void setSetName(SetDiscountCodeName setName) {
    this.setName = setName;
  }

  public SetDiscountCodeValidFrom getSetValidFrom() {
    return setValidFrom;
  }

  public void setSetValidFrom(SetDiscountCodeValidFrom setValidFrom) {
    this.setValidFrom = setValidFrom;
  }

  public SetDiscountCodeValidFromAndUntil getSetValidFromAndUntil() {
    return setValidFromAndUntil;
  }

  public void setSetValidFromAndUntil(SetDiscountCodeValidFromAndUntil setValidFromAndUntil) {
    this.setValidFromAndUntil = setValidFromAndUntil;
  }

  public SetDiscountCodeValidUntil getSetValidUntil() {
    return setValidUntil;
  }

  public void setSetValidUntil(SetDiscountCodeValidUntil setValidUntil) {
    this.setValidUntil = setValidUntil;
  }

  @Override
  public String toString() {
    return "DiscountCodeUpdateAction{changeCartDiscounts='" + changeCartDiscounts + "', changeGroups='" + changeGroups + "', changeIsActive='" + changeIsActive + "', setCartPredicate='" + setCartPredicate + "', setCustomField='" + setCustomField + "', setCustomType='" + setCustomType + "', setDescription='" + setDescription + "', setKey='" + setKey + "', setMaxApplications='" + setMaxApplications + "', setMaxApplicationsPerCustomer='" + setMaxApplicationsPerCustomer + "', setName='" + setName + "', setValidFrom='" + setValidFrom + "', setValidFromAndUntil='" + setValidFromAndUntil + "', setValidUntil='" + setValidUntil + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DiscountCodeUpdateAction that = (DiscountCodeUpdateAction) o;
    return Objects.equals(changeCartDiscounts, that.changeCartDiscounts) &&
        Objects.equals(changeGroups, that.changeGroups) &&
        Objects.equals(changeIsActive, that.changeIsActive) &&
        Objects.equals(setCartPredicate, that.setCartPredicate) &&
        Objects.equals(setCustomField, that.setCustomField) &&
        Objects.equals(setCustomType, that.setCustomType) &&
        Objects.equals(setDescription, that.setDescription) &&
        Objects.equals(setKey, that.setKey) &&
        Objects.equals(setMaxApplications, that.setMaxApplications) &&
        Objects.equals(setMaxApplicationsPerCustomer, that.setMaxApplicationsPerCustomer) &&
        Objects.equals(setName, that.setName) &&
        Objects.equals(setValidFrom, that.setValidFrom) &&
        Objects.equals(setValidFromAndUntil, that.setValidFromAndUntil) &&
        Objects.equals(setValidUntil, that.setValidUntil);
  }

  @Override
  public int hashCode() {
    return Objects.hash(changeCartDiscounts, changeGroups, changeIsActive, setCartPredicate, setCustomField, setCustomType, setDescription, setKey, setMaxApplications, setMaxApplicationsPerCustomer, setName, setValidFrom, setValidFromAndUntil, setValidUntil);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ChangeDiscountCodeCartDiscounts changeCartDiscounts;

    private ChangeDiscountCodeGroups changeGroups;

    private ChangeDiscountCodeIsActive changeIsActive;

    private SetDiscountCodeCartPredicate setCartPredicate;

    private SetDiscountCodeCustomField setCustomField;

    private SetDiscountCodeCustomType setCustomType;

    private SetDiscountCodeDescription setDescription;

    private SetDiscountCodeKey setKey;

    private SetDiscountCodeMaxApplications setMaxApplications;

    private SetDiscountCodeMaxApplicationsPerCustomer setMaxApplicationsPerCustomer;

    private SetDiscountCodeName setName;

    private SetDiscountCodeValidFrom setValidFrom;

    private SetDiscountCodeValidFromAndUntil setValidFromAndUntil;

    private SetDiscountCodeValidUntil setValidUntil;

    public DiscountCodeUpdateAction build() {
      DiscountCodeUpdateAction result = new DiscountCodeUpdateAction();
      result.changeCartDiscounts = this.changeCartDiscounts;
      result.changeGroups = this.changeGroups;
      result.changeIsActive = this.changeIsActive;
      result.setCartPredicate = this.setCartPredicate;
      result.setCustomField = this.setCustomField;
      result.setCustomType = this.setCustomType;
      result.setDescription = this.setDescription;
      result.setKey = this.setKey;
      result.setMaxApplications = this.setMaxApplications;
      result.setMaxApplicationsPerCustomer = this.setMaxApplicationsPerCustomer;
      result.setName = this.setName;
      result.setValidFrom = this.setValidFrom;
      result.setValidFromAndUntil = this.setValidFromAndUntil;
      result.setValidUntil = this.setValidUntil;
      return result;
    }

    public Builder changeCartDiscounts(ChangeDiscountCodeCartDiscounts changeCartDiscounts) {
      this.changeCartDiscounts = changeCartDiscounts;
      return this;
    }

    public Builder changeGroups(ChangeDiscountCodeGroups changeGroups) {
      this.changeGroups = changeGroups;
      return this;
    }

    public Builder changeIsActive(ChangeDiscountCodeIsActive changeIsActive) {
      this.changeIsActive = changeIsActive;
      return this;
    }

    public Builder setCartPredicate(SetDiscountCodeCartPredicate setCartPredicate) {
      this.setCartPredicate = setCartPredicate;
      return this;
    }

    public Builder setCustomField(SetDiscountCodeCustomField setCustomField) {
      this.setCustomField = setCustomField;
      return this;
    }

    public Builder setCustomType(SetDiscountCodeCustomType setCustomType) {
      this.setCustomType = setCustomType;
      return this;
    }

    public Builder setDescription(SetDiscountCodeDescription setDescription) {
      this.setDescription = setDescription;
      return this;
    }

    public Builder setKey(SetDiscountCodeKey setKey) {
      this.setKey = setKey;
      return this;
    }

    public Builder setMaxApplications(SetDiscountCodeMaxApplications setMaxApplications) {
      this.setMaxApplications = setMaxApplications;
      return this;
    }

    public Builder setMaxApplicationsPerCustomer(
        SetDiscountCodeMaxApplicationsPerCustomer setMaxApplicationsPerCustomer) {
      this.setMaxApplicationsPerCustomer = setMaxApplicationsPerCustomer;
      return this;
    }

    public Builder setName(SetDiscountCodeName setName) {
      this.setName = setName;
      return this;
    }

    public Builder setValidFrom(SetDiscountCodeValidFrom setValidFrom) {
      this.setValidFrom = setValidFrom;
      return this;
    }

    public Builder setValidFromAndUntil(SetDiscountCodeValidFromAndUntil setValidFromAndUntil) {
      this.setValidFromAndUntil = setValidFromAndUntil;
      return this;
    }

    public Builder setValidUntil(SetDiscountCodeValidUntil setValidUntil) {
      this.setValidUntil = setValidUntil;
      return this;
    }
  }
}
