package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class DiscountOnTotalPrice {
  private BaseMoney discountedAmount;

  private List<DiscountedTotalPricePortion> includedDiscounts;

  private BaseMoney discountedNetAmount;

  private BaseMoney discountedGrossAmount;

  public DiscountOnTotalPrice() {
  }

  public DiscountOnTotalPrice(BaseMoney discountedAmount,
      List<DiscountedTotalPricePortion> includedDiscounts, BaseMoney discountedNetAmount,
      BaseMoney discountedGrossAmount) {
    this.discountedAmount = discountedAmount;
    this.includedDiscounts = includedDiscounts;
    this.discountedNetAmount = discountedNetAmount;
    this.discountedGrossAmount = discountedGrossAmount;
  }

  public BaseMoney getDiscountedAmount() {
    return discountedAmount;
  }

  public void setDiscountedAmount(BaseMoney discountedAmount) {
    this.discountedAmount = discountedAmount;
  }

  public List<DiscountedTotalPricePortion> getIncludedDiscounts() {
    return includedDiscounts;
  }

  public void setIncludedDiscounts(List<DiscountedTotalPricePortion> includedDiscounts) {
    this.includedDiscounts = includedDiscounts;
  }

  public BaseMoney getDiscountedNetAmount() {
    return discountedNetAmount;
  }

  public void setDiscountedNetAmount(BaseMoney discountedNetAmount) {
    this.discountedNetAmount = discountedNetAmount;
  }

  public BaseMoney getDiscountedGrossAmount() {
    return discountedGrossAmount;
  }

  public void setDiscountedGrossAmount(BaseMoney discountedGrossAmount) {
    this.discountedGrossAmount = discountedGrossAmount;
  }

  @Override
  public String toString() {
    return "DiscountOnTotalPrice{discountedAmount='" + discountedAmount + "', includedDiscounts='" + includedDiscounts + "', discountedNetAmount='" + discountedNetAmount + "', discountedGrossAmount='" + discountedGrossAmount + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DiscountOnTotalPrice that = (DiscountOnTotalPrice) o;
    return Objects.equals(discountedAmount, that.discountedAmount) &&
        Objects.equals(includedDiscounts, that.includedDiscounts) &&
        Objects.equals(discountedNetAmount, that.discountedNetAmount) &&
        Objects.equals(discountedGrossAmount, that.discountedGrossAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(discountedAmount, includedDiscounts, discountedNetAmount, discountedGrossAmount);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private BaseMoney discountedAmount;

    private List<DiscountedTotalPricePortion> includedDiscounts;

    private BaseMoney discountedNetAmount;

    private BaseMoney discountedGrossAmount;

    public DiscountOnTotalPrice build() {
      DiscountOnTotalPrice result = new DiscountOnTotalPrice();
      result.discountedAmount = this.discountedAmount;
      result.includedDiscounts = this.includedDiscounts;
      result.discountedNetAmount = this.discountedNetAmount;
      result.discountedGrossAmount = this.discountedGrossAmount;
      return result;
    }

    public Builder discountedAmount(BaseMoney discountedAmount) {
      this.discountedAmount = discountedAmount;
      return this;
    }

    public Builder includedDiscounts(List<DiscountedTotalPricePortion> includedDiscounts) {
      this.includedDiscounts = includedDiscounts;
      return this;
    }

    public Builder discountedNetAmount(BaseMoney discountedNetAmount) {
      this.discountedNetAmount = discountedNetAmount;
      return this;
    }

    public Builder discountedGrossAmount(BaseMoney discountedGrossAmount) {
      this.discountedGrossAmount = discountedGrossAmount;
      return this;
    }
  }
}
