package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class DiscountedLineItemPriceForQuantity {
  private Long quantity;

  private DiscountedLineItemPrice discountedPrice;

  public DiscountedLineItemPriceForQuantity() {
  }

  public DiscountedLineItemPriceForQuantity(Long quantity,
      DiscountedLineItemPrice discountedPrice) {
    this.quantity = quantity;
    this.discountedPrice = discountedPrice;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public DiscountedLineItemPrice getDiscountedPrice() {
    return discountedPrice;
  }

  public void setDiscountedPrice(DiscountedLineItemPrice discountedPrice) {
    this.discountedPrice = discountedPrice;
  }

  @Override
  public String toString() {
    return "DiscountedLineItemPriceForQuantity{quantity='" + quantity + "', discountedPrice='" + discountedPrice + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DiscountedLineItemPriceForQuantity that = (DiscountedLineItemPriceForQuantity) o;
    return Objects.equals(quantity, that.quantity) &&
        Objects.equals(discountedPrice, that.discountedPrice);
  }

  @Override
  public int hashCode() {
    return Objects.hash(quantity, discountedPrice);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Long quantity;

    private DiscountedLineItemPrice discountedPrice;

    public DiscountedLineItemPriceForQuantity build() {
      DiscountedLineItemPriceForQuantity result = new DiscountedLineItemPriceForQuantity();
      result.quantity = this.quantity;
      result.discountedPrice = this.discountedPrice;
      return result;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }

    public Builder discountedPrice(DiscountedLineItemPrice discountedPrice) {
      this.discountedPrice = discountedPrice;
      return this;
    }
  }
}
