package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class DiscountedProductPriceValueInput {
  private BaseMoneyInput value;

  private ResourceIdentifierInput discount;

  public DiscountedProductPriceValueInput() {
  }

  public DiscountedProductPriceValueInput(BaseMoneyInput value, ResourceIdentifierInput discount) {
    this.value = value;
    this.discount = discount;
  }

  public BaseMoneyInput getValue() {
    return value;
  }

  public void setValue(BaseMoneyInput value) {
    this.value = value;
  }

  public ResourceIdentifierInput getDiscount() {
    return discount;
  }

  public void setDiscount(ResourceIdentifierInput discount) {
    this.discount = discount;
  }

  @Override
  public String toString() {
    return "DiscountedProductPriceValueInput{value='" + value + "', discount='" + discount + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DiscountedProductPriceValueInput that = (DiscountedProductPriceValueInput) o;
    return Objects.equals(value, that.value) &&
        Objects.equals(discount, that.discount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value, discount);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private BaseMoneyInput value;

    private ResourceIdentifierInput discount;

    public DiscountedProductPriceValueInput build() {
      DiscountedProductPriceValueInput result = new DiscountedProductPriceValueInput();
      result.value = this.value;
      result.discount = this.discount;
      return result;
    }

    public Builder value(BaseMoneyInput value) {
      this.value = value;
      return this;
    }

    public Builder discount(ResourceIdentifierInput discount) {
      this.discount = discount;
      return this;
    }
  }
}
