package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class DiscountedProductSearchPriceValue {
  private BaseMoney value;

  private Reference discountRef;

  private ProductDiscount discount;

  public DiscountedProductSearchPriceValue() {
  }

  public DiscountedProductSearchPriceValue(BaseMoney value, Reference discountRef,
      ProductDiscount discount) {
    this.value = value;
    this.discountRef = discountRef;
    this.discount = discount;
  }

  public BaseMoney getValue() {
    return value;
  }

  public void setValue(BaseMoney value) {
    this.value = value;
  }

  public Reference getDiscountRef() {
    return discountRef;
  }

  public void setDiscountRef(Reference discountRef) {
    this.discountRef = discountRef;
  }

  public ProductDiscount getDiscount() {
    return discount;
  }

  public void setDiscount(ProductDiscount discount) {
    this.discount = discount;
  }

  @Override
  public String toString() {
    return "DiscountedProductSearchPriceValue{value='" + value + "', discountRef='" + discountRef + "', discount='" + discount + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DiscountedProductSearchPriceValue that = (DiscountedProductSearchPriceValue) o;
    return Objects.equals(value, that.value) &&
        Objects.equals(discountRef, that.discountRef) &&
        Objects.equals(discount, that.discount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value, discountRef, discount);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private BaseMoney value;

    private Reference discountRef;

    private ProductDiscount discount;

    public DiscountedProductSearchPriceValue build() {
      DiscountedProductSearchPriceValue result = new DiscountedProductSearchPriceValue();
      result.value = this.value;
      result.discountRef = this.discountRef;
      result.discount = this.discount;
      return result;
    }

    public Builder value(BaseMoney value) {
      this.value = value;
      return this;
    }

    public Builder discountRef(Reference discountRef) {
      this.discountRef = discountRef;
      return this;
    }

    public Builder discount(ProductDiscount discount) {
      this.discount = discount;
      return this;
    }
  }
}
