package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class EnumAttribute implements com.commercetools.graphql.api.types.Attribute {
  private String key;

  private String label;

  private String name;

  public EnumAttribute() {
  }

  public EnumAttribute(String key, String label, String name) {
    this.key = key;
    this.label = label;
    this.name = name;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getLabel() {
    return label;
  }

  public void setLabel(String label) {
    this.label = label;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @Override
  public String toString() {
    return "EnumAttribute{key='" + key + "', label='" + label + "', name='" + name + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EnumAttribute that = (EnumAttribute) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(label, that.label) &&
        Objects.equals(name, that.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, label, name);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private String label;

    private String name;

    public EnumAttribute build() {
      EnumAttribute result = new EnumAttribute();
      result.key = this.key;
      result.label = this.label;
      result.name = this.name;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder label(String label) {
      this.label = label;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }
  }
}
