package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class EnumType implements com.commercetools.graphql.api.types.FieldType {
  private List<EnumValue> values;

  private String name;

  public EnumType() {
  }

  public EnumType(List<EnumValue> values, String name) {
    this.values = values;
    this.name = name;
  }

  public List<EnumValue> getValues() {
    return values;
  }

  public void setValues(List<EnumValue> values) {
    this.values = values;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @Override
  public String toString() {
    return "EnumType{values='" + values + "', name='" + name + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EnumType that = (EnumType) o;
    return Objects.equals(values, that.values) &&
        Objects.equals(name, that.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(values, name);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<EnumValue> values;

    private String name;

    public EnumType build() {
      EnumType result = new EnumType();
      result.values = this.values;
      result.name = this.name;
      return result;
    }

    public Builder values(List<EnumValue> values) {
      this.values = values;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }
  }
}
