package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class EnumTypeDraft {
  private List<PlainEnumValueDraft> values;

  public EnumTypeDraft() {
  }

  public EnumTypeDraft(List<PlainEnumValueDraft> values) {
    this.values = values;
  }

  public List<PlainEnumValueDraft> getValues() {
    return values;
  }

  public void setValues(List<PlainEnumValueDraft> values) {
    this.values = values;
  }

  @Override
  public String toString() {
    return "EnumTypeDraft{values='" + values + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EnumTypeDraft that = (EnumTypeDraft) o;
    return Objects.equals(values, that.values);
  }

  @Override
  public int hashCode() {
    return Objects.hash(values);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<PlainEnumValueDraft> values;

    public EnumTypeDraft build() {
      EnumTypeDraft result = new EnumTypeDraft();
      result.values = this.values;
      return result;
    }

    public Builder values(List<PlainEnumValueDraft> values) {
      this.values = values;
      return this;
    }
  }
}
