package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class EventBridgeDestination implements com.commercetools.graphql.api.types.Destination {
  private String source;

  private String region;

  private String accountId;

  private String type;

  public EventBridgeDestination() {
  }

  public EventBridgeDestination(String source, String region, String accountId, String type) {
    this.source = source;
    this.region = region;
    this.accountId = accountId;
    this.type = type;
  }

  public String getSource() {
    return source;
  }

  public void setSource(String source) {
    this.source = source;
  }

  public String getRegion() {
    return region;
  }

  public void setRegion(String region) {
    this.region = region;
  }

  public String getAccountId() {
    return accountId;
  }

  public void setAccountId(String accountId) {
    this.accountId = accountId;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "EventBridgeDestination{source='" + source + "', region='" + region + "', accountId='" + accountId + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EventBridgeDestination that = (EventBridgeDestination) o;
    return Objects.equals(source, that.source) &&
        Objects.equals(region, that.region) &&
        Objects.equals(accountId, that.accountId) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(source, region, accountId, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String source;

    private String region;

    private String accountId;

    private String type;

    public EventBridgeDestination build() {
      EventBridgeDestination result = new EventBridgeDestination();
      result.source = this.source;
      result.region = this.region;
      result.accountId = this.accountId;
      result.type = this.type;
      return result;
    }

    public Builder source(String source) {
      this.source = source;
      return this;
    }

    public Builder region(String region) {
      this.region = region;
      return this;
    }

    public Builder accountId(String accountId) {
      this.accountId = accountId;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
