package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class EventBridgeDestinationInput {
  private String region;

  private String accountId;

  public EventBridgeDestinationInput() {
  }

  public EventBridgeDestinationInput(String region, String accountId) {
    this.region = region;
    this.accountId = accountId;
  }

  public String getRegion() {
    return region;
  }

  public void setRegion(String region) {
    this.region = region;
  }

  public String getAccountId() {
    return accountId;
  }

  public void setAccountId(String accountId) {
    this.accountId = accountId;
  }

  @Override
  public String toString() {
    return "EventBridgeDestinationInput{region='" + region + "', accountId='" + accountId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EventBridgeDestinationInput that = (EventBridgeDestinationInput) o;
    return Objects.equals(region, that.region) &&
        Objects.equals(accountId, that.accountId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(region, accountId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String region;

    private String accountId;

    public EventBridgeDestinationInput build() {
      EventBridgeDestinationInput result = new EventBridgeDestinationInput();
      result.region = this.region;
      result.accountId = this.accountId;
      return result;
    }

    public Builder region(String region) {
      this.region = region;
      return this;
    }

    public Builder accountId(String accountId) {
      this.accountId = accountId;
      return this;
    }
  }
}
