package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.String;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = AWSLambdaDestination.class, name = "AWSLambdaDestination"),
    @JsonSubTypes.Type(value = GoogleCloudFunctionDestination.class, name = "GoogleCloudFunctionDestination"),
    @JsonSubTypes.Type(value = HttpDestination.class, name = "HttpDestination")
})
public interface ExtensionDestination {
  String getType();

  void setType(String type);
}
