package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ExtensionDraft {
  private String key;

  private ExtensionDestinationInput destination;

  private List<TriggerInput> triggers;

  private Integer timeoutInMs;

  public ExtensionDraft() {
  }

  public ExtensionDraft(String key, ExtensionDestinationInput destination,
      List<TriggerInput> triggers, Integer timeoutInMs) {
    this.key = key;
    this.destination = destination;
    this.triggers = triggers;
    this.timeoutInMs = timeoutInMs;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public ExtensionDestinationInput getDestination() {
    return destination;
  }

  public void setDestination(ExtensionDestinationInput destination) {
    this.destination = destination;
  }

  public List<TriggerInput> getTriggers() {
    return triggers;
  }

  public void setTriggers(List<TriggerInput> triggers) {
    this.triggers = triggers;
  }

  public Integer getTimeoutInMs() {
    return timeoutInMs;
  }

  public void setTimeoutInMs(Integer timeoutInMs) {
    this.timeoutInMs = timeoutInMs;
  }

  @Override
  public String toString() {
    return "ExtensionDraft{key='" + key + "', destination='" + destination + "', triggers='" + triggers + "', timeoutInMs='" + timeoutInMs + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ExtensionDraft that = (ExtensionDraft) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(destination, that.destination) &&
        Objects.equals(triggers, that.triggers) &&
        Objects.equals(timeoutInMs, that.timeoutInMs);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, destination, triggers, timeoutInMs);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private ExtensionDestinationInput destination;

    private List<TriggerInput> triggers;

    private Integer timeoutInMs;

    public ExtensionDraft build() {
      ExtensionDraft result = new ExtensionDraft();
      result.key = this.key;
      result.destination = this.destination;
      result.triggers = this.triggers;
      result.timeoutInMs = this.timeoutInMs;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder destination(ExtensionDestinationInput destination) {
      this.destination = destination;
      return this;
    }

    public Builder triggers(List<TriggerInput> triggers) {
      this.triggers = triggers;
      return this;
    }

    public Builder timeoutInMs(Integer timeoutInMs) {
      this.timeoutInMs = timeoutInMs;
      return this;
    }
  }
}
