package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ExternalOAuth {
  private String url;

  private String authorizationHeader;

  public ExternalOAuth() {
  }

  public ExternalOAuth(String url, String authorizationHeader) {
    this.url = url;
    this.authorizationHeader = authorizationHeader;
  }

  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  public String getAuthorizationHeader() {
    return authorizationHeader;
  }

  public void setAuthorizationHeader(String authorizationHeader) {
    this.authorizationHeader = authorizationHeader;
  }

  @Override
  public String toString() {
    return "ExternalOAuth{url='" + url + "', authorizationHeader='" + authorizationHeader + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ExternalOAuth that = (ExternalOAuth) o;
    return Objects.equals(url, that.url) &&
        Objects.equals(authorizationHeader, that.authorizationHeader);
  }

  @Override
  public int hashCode() {
    return Objects.hash(url, authorizationHeader);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String url;

    private String authorizationHeader;

    public ExternalOAuth build() {
      ExternalOAuth result = new ExternalOAuth();
      result.url = this.url;
      result.authorizationHeader = this.authorizationHeader;
      return result;
    }

    public Builder url(String url) {
      this.url = url;
      return this;
    }

    public Builder authorizationHeader(String authorizationHeader) {
      this.authorizationHeader = authorizationHeader;
      return this;
    }
  }
}
