package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.String;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = RangeFacetResult.class, name = "RangeFacetResult"),
    @JsonSubTypes.Type(value = TermsFacetResult.class, name = "TermsFacetResult"),
    @JsonSubTypes.Type(value = ValueFacetResult.class, name = "ValueFacetResult")
})
public interface FacetResult {
  String getType();

  void setType(String type);
}
