package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class FieldTypeEnumTypeDraft {
  private List<EnumValueInput> values;

  public FieldTypeEnumTypeDraft() {
  }

  public FieldTypeEnumTypeDraft(List<EnumValueInput> values) {
    this.values = values;
  }

  public List<EnumValueInput> getValues() {
    return values;
  }

  public void setValues(List<EnumValueInput> values) {
    this.values = values;
  }

  @Override
  public String toString() {
    return "FieldTypeEnumTypeDraft{values='" + values + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FieldTypeEnumTypeDraft that = (FieldTypeEnumTypeDraft) o;
    return Objects.equals(values, that.values);
  }

  @Override
  public int hashCode() {
    return Objects.hash(values);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<EnumValueInput> values;

    public FieldTypeEnumTypeDraft build() {
      FieldTypeEnumTypeDraft result = new FieldTypeEnumTypeDraft();
      result.values = this.values;
      return result;
    }

    public Builder values(List<EnumValueInput> values) {
      this.values = values;
      return this;
    }
  }
}
