package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class FieldTypeInput {
  private FieldTypeSetTypeDraft Set;

  private SimpleFieldTypeDraft String;

  private SimpleFieldTypeDraft LocalizedString;

  private SimpleFieldTypeDraft Number;

  private SimpleFieldTypeDraft Money;

  private SimpleFieldTypeDraft Date;

  private SimpleFieldTypeDraft Time;

  private SimpleFieldTypeDraft DateTime;

  private SimpleFieldTypeDraft Boolean;

  private FieldTypeEnumTypeDraft Enum;

  private FieldTypeLocalizedEnumTypeDraft LocalizedEnum;

  private FieldTypeReferenceTypeDraft Reference;

  public FieldTypeInput() {
  }

  public FieldTypeInput(FieldTypeSetTypeDraft Set, SimpleFieldTypeDraft String,
      SimpleFieldTypeDraft LocalizedString, SimpleFieldTypeDraft Number, SimpleFieldTypeDraft Money,
      SimpleFieldTypeDraft Date, SimpleFieldTypeDraft Time, SimpleFieldTypeDraft DateTime,
      SimpleFieldTypeDraft Boolean, FieldTypeEnumTypeDraft Enum,
      FieldTypeLocalizedEnumTypeDraft LocalizedEnum, FieldTypeReferenceTypeDraft Reference) {
    this.Set = Set;
    this.String = String;
    this.LocalizedString = LocalizedString;
    this.Number = Number;
    this.Money = Money;
    this.Date = Date;
    this.Time = Time;
    this.DateTime = DateTime;
    this.Boolean = Boolean;
    this.Enum = Enum;
    this.LocalizedEnum = LocalizedEnum;
    this.Reference = Reference;
  }

  public FieldTypeSetTypeDraft getSet() {
    return Set;
  }

  public void setSet(FieldTypeSetTypeDraft Set) {
    this.Set = Set;
  }

  public SimpleFieldTypeDraft getString() {
    return String;
  }

  public void setString(SimpleFieldTypeDraft String) {
    this.String = String;
  }

  public SimpleFieldTypeDraft getLocalizedString() {
    return LocalizedString;
  }

  public void setLocalizedString(SimpleFieldTypeDraft LocalizedString) {
    this.LocalizedString = LocalizedString;
  }

  public SimpleFieldTypeDraft getNumber() {
    return Number;
  }

  public void setNumber(SimpleFieldTypeDraft Number) {
    this.Number = Number;
  }

  public SimpleFieldTypeDraft getMoney() {
    return Money;
  }

  public void setMoney(SimpleFieldTypeDraft Money) {
    this.Money = Money;
  }

  public SimpleFieldTypeDraft getDate() {
    return Date;
  }

  public void setDate(SimpleFieldTypeDraft Date) {
    this.Date = Date;
  }

  public SimpleFieldTypeDraft getTime() {
    return Time;
  }

  public void setTime(SimpleFieldTypeDraft Time) {
    this.Time = Time;
  }

  public SimpleFieldTypeDraft getDateTime() {
    return DateTime;
  }

  public void setDateTime(SimpleFieldTypeDraft DateTime) {
    this.DateTime = DateTime;
  }

  public SimpleFieldTypeDraft getBoolean() {
    return Boolean;
  }

  public void setBoolean(SimpleFieldTypeDraft Boolean) {
    this.Boolean = Boolean;
  }

  public FieldTypeEnumTypeDraft getEnum() {
    return Enum;
  }

  public void setEnum(FieldTypeEnumTypeDraft Enum) {
    this.Enum = Enum;
  }

  public FieldTypeLocalizedEnumTypeDraft getLocalizedEnum() {
    return LocalizedEnum;
  }

  public void setLocalizedEnum(FieldTypeLocalizedEnumTypeDraft LocalizedEnum) {
    this.LocalizedEnum = LocalizedEnum;
  }

  public FieldTypeReferenceTypeDraft getReference() {
    return Reference;
  }

  public void setReference(FieldTypeReferenceTypeDraft Reference) {
    this.Reference = Reference;
  }

  @Override
  public String toString() {
    return "FieldTypeInput{Set='" + Set + "', String='" + String + "', LocalizedString='" + LocalizedString + "', Number='" + Number + "', Money='" + Money + "', Date='" + Date + "', Time='" + Time + "', DateTime='" + DateTime + "', Boolean='" + Boolean + "', Enum='" + Enum + "', LocalizedEnum='" + LocalizedEnum + "', Reference='" + Reference + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FieldTypeInput that = (FieldTypeInput) o;
    return Objects.equals(Set, that.Set) &&
        Objects.equals(String, that.String) &&
        Objects.equals(LocalizedString, that.LocalizedString) &&
        Objects.equals(Number, that.Number) &&
        Objects.equals(Money, that.Money) &&
        Objects.equals(Date, that.Date) &&
        Objects.equals(Time, that.Time) &&
        Objects.equals(DateTime, that.DateTime) &&
        Objects.equals(Boolean, that.Boolean) &&
        Objects.equals(Enum, that.Enum) &&
        Objects.equals(LocalizedEnum, that.LocalizedEnum) &&
        Objects.equals(Reference, that.Reference);
  }

  @Override
  public int hashCode() {
    return Objects.hash(Set, String, LocalizedString, Number, Money, Date, Time, DateTime, Boolean, Enum, LocalizedEnum, Reference);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private FieldTypeSetTypeDraft Set;

    private SimpleFieldTypeDraft String;

    private SimpleFieldTypeDraft LocalizedString;

    private SimpleFieldTypeDraft Number;

    private SimpleFieldTypeDraft Money;

    private SimpleFieldTypeDraft Date;

    private SimpleFieldTypeDraft Time;

    private SimpleFieldTypeDraft DateTime;

    private SimpleFieldTypeDraft Boolean;

    private FieldTypeEnumTypeDraft Enum;

    private FieldTypeLocalizedEnumTypeDraft LocalizedEnum;

    private FieldTypeReferenceTypeDraft Reference;

    public FieldTypeInput build() {
      FieldTypeInput result = new FieldTypeInput();
      result.Set = this.Set;
      result.String = this.String;
      result.LocalizedString = this.LocalizedString;
      result.Number = this.Number;
      result.Money = this.Money;
      result.Date = this.Date;
      result.Time = this.Time;
      result.DateTime = this.DateTime;
      result.Boolean = this.Boolean;
      result.Enum = this.Enum;
      result.LocalizedEnum = this.LocalizedEnum;
      result.Reference = this.Reference;
      return result;
    }

    public Builder Set(FieldTypeSetTypeDraft Set) {
      this.Set = Set;
      return this;
    }

    public Builder String(SimpleFieldTypeDraft String) {
      this.String = String;
      return this;
    }

    public Builder LocalizedString(SimpleFieldTypeDraft LocalizedString) {
      this.LocalizedString = LocalizedString;
      return this;
    }

    public Builder Number(SimpleFieldTypeDraft Number) {
      this.Number = Number;
      return this;
    }

    public Builder Money(SimpleFieldTypeDraft Money) {
      this.Money = Money;
      return this;
    }

    public Builder Date(SimpleFieldTypeDraft Date) {
      this.Date = Date;
      return this;
    }

    public Builder Time(SimpleFieldTypeDraft Time) {
      this.Time = Time;
      return this;
    }

    public Builder DateTime(SimpleFieldTypeDraft DateTime) {
      this.DateTime = DateTime;
      return this;
    }

    public Builder Boolean(SimpleFieldTypeDraft Boolean) {
      this.Boolean = Boolean;
      return this;
    }

    public Builder Enum(FieldTypeEnumTypeDraft Enum) {
      this.Enum = Enum;
      return this;
    }

    public Builder LocalizedEnum(FieldTypeLocalizedEnumTypeDraft LocalizedEnum) {
      this.LocalizedEnum = LocalizedEnum;
      return this;
    }

    public Builder Reference(FieldTypeReferenceTypeDraft Reference) {
      this.Reference = Reference;
      return this;
    }
  }
}
