package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class FieldTypeLocalizedEnumTypeDraft {
  private List<LocalizedEnumValueInput> values;

  public FieldTypeLocalizedEnumTypeDraft() {
  }

  public FieldTypeLocalizedEnumTypeDraft(List<LocalizedEnumValueInput> values) {
    this.values = values;
  }

  public List<LocalizedEnumValueInput> getValues() {
    return values;
  }

  public void setValues(List<LocalizedEnumValueInput> values) {
    this.values = values;
  }

  @Override
  public String toString() {
    return "FieldTypeLocalizedEnumTypeDraft{values='" + values + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FieldTypeLocalizedEnumTypeDraft that = (FieldTypeLocalizedEnumTypeDraft) o;
    return Objects.equals(values, that.values);
  }

  @Override
  public int hashCode() {
    return Objects.hash(values);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<LocalizedEnumValueInput> values;

    public FieldTypeLocalizedEnumTypeDraft build() {
      FieldTypeLocalizedEnumTypeDraft result = new FieldTypeLocalizedEnumTypeDraft();
      result.values = this.values;
      return result;
    }

    public Builder values(List<LocalizedEnumValueInput> values) {
      this.values = values;
      return this;
    }
  }
}
