package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class FieldTypeReferenceTypeDraft {
  private String referenceTypeId;

  public FieldTypeReferenceTypeDraft() {
  }

  public FieldTypeReferenceTypeDraft(String referenceTypeId) {
    this.referenceTypeId = referenceTypeId;
  }

  public String getReferenceTypeId() {
    return referenceTypeId;
  }

  public void setReferenceTypeId(String referenceTypeId) {
    this.referenceTypeId = referenceTypeId;
  }

  @Override
  public String toString() {
    return "FieldTypeReferenceTypeDraft{referenceTypeId='" + referenceTypeId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FieldTypeReferenceTypeDraft that = (FieldTypeReferenceTypeDraft) o;
    return Objects.equals(referenceTypeId, that.referenceTypeId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(referenceTypeId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String referenceTypeId;

    public FieldTypeReferenceTypeDraft build() {
      FieldTypeReferenceTypeDraft result = new FieldTypeReferenceTypeDraft();
      result.referenceTypeId = this.referenceTypeId;
      return result;
    }

    public Builder referenceTypeId(String referenceTypeId) {
      this.referenceTypeId = referenceTypeId;
      return this;
    }
  }
}
