package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class FixedPriceCartDiscountValue implements com.commercetools.graphql.api.types.CartDiscountValue {
  private String type;

  private List<BaseMoney> money;

  private DiscountApplicationMode applicationMode;

  public FixedPriceCartDiscountValue() {
  }

  public FixedPriceCartDiscountValue(String type, List<BaseMoney> money,
      DiscountApplicationMode applicationMode) {
    this.type = type;
    this.money = money;
    this.applicationMode = applicationMode;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public List<BaseMoney> getMoney() {
    return money;
  }

  public void setMoney(List<BaseMoney> money) {
    this.money = money;
  }

  public DiscountApplicationMode getApplicationMode() {
    return applicationMode;
  }

  public void setApplicationMode(DiscountApplicationMode applicationMode) {
    this.applicationMode = applicationMode;
  }

  @Override
  public String toString() {
    return "FixedPriceCartDiscountValue{type='" + type + "', money='" + money + "', applicationMode='" + applicationMode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FixedPriceCartDiscountValue that = (FixedPriceCartDiscountValue) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(money, that.money) &&
        Objects.equals(applicationMode, that.applicationMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, money, applicationMode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private List<BaseMoney> money;

    private DiscountApplicationMode applicationMode;

    public FixedPriceCartDiscountValue build() {
      FixedPriceCartDiscountValue result = new FixedPriceCartDiscountValue();
      result.type = this.type;
      result.money = this.money;
      result.applicationMode = this.applicationMode;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder money(List<BaseMoney> money) {
      this.money = money;
      return this;
    }

    public Builder applicationMode(DiscountApplicationMode applicationMode) {
      this.applicationMode = applicationMode;
      return this;
    }
  }
}
