package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class GiftLineItemValueInput {
  private ResourceIdentifierInput product;

  private Integer variantId;

  private ResourceIdentifierInput distributionChannel;

  private ResourceIdentifierInput supplyChannel;

  public GiftLineItemValueInput() {
  }

  public GiftLineItemValueInput(ResourceIdentifierInput product, Integer variantId,
      ResourceIdentifierInput distributionChannel, ResourceIdentifierInput supplyChannel) {
    this.product = product;
    this.variantId = variantId;
    this.distributionChannel = distributionChannel;
    this.supplyChannel = supplyChannel;
  }

  public ResourceIdentifierInput getProduct() {
    return product;
  }

  public void setProduct(ResourceIdentifierInput product) {
    this.product = product;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public ResourceIdentifierInput getDistributionChannel() {
    return distributionChannel;
  }

  public void setDistributionChannel(ResourceIdentifierInput distributionChannel) {
    this.distributionChannel = distributionChannel;
  }

  public ResourceIdentifierInput getSupplyChannel() {
    return supplyChannel;
  }

  public void setSupplyChannel(ResourceIdentifierInput supplyChannel) {
    this.supplyChannel = supplyChannel;
  }

  @Override
  public String toString() {
    return "GiftLineItemValueInput{product='" + product + "', variantId='" + variantId + "', distributionChannel='" + distributionChannel + "', supplyChannel='" + supplyChannel + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GiftLineItemValueInput that = (GiftLineItemValueInput) o;
    return Objects.equals(product, that.product) &&
        Objects.equals(variantId, that.variantId) &&
        Objects.equals(distributionChannel, that.distributionChannel) &&
        Objects.equals(supplyChannel, that.supplyChannel);
  }

  @Override
  public int hashCode() {
    return Objects.hash(product, variantId, distributionChannel, supplyChannel);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput product;

    private Integer variantId;

    private ResourceIdentifierInput distributionChannel;

    private ResourceIdentifierInput supplyChannel;

    public GiftLineItemValueInput build() {
      GiftLineItemValueInput result = new GiftLineItemValueInput();
      result.product = this.product;
      result.variantId = this.variantId;
      result.distributionChannel = this.distributionChannel;
      result.supplyChannel = this.supplyChannel;
      return result;
    }

    public Builder product(ResourceIdentifierInput product) {
      this.product = product;
      return this;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder distributionChannel(ResourceIdentifierInput distributionChannel) {
      this.distributionChannel = distributionChannel;
      return this;
    }

    public Builder supplyChannel(ResourceIdentifierInput supplyChannel) {
      this.supplyChannel = supplyChannel;
      return this;
    }
  }
}
