package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class GoogleCloudFunctionDestination implements com.commercetools.graphql.api.types.ExtensionDestination {
  private String url;

  private String type;

  public GoogleCloudFunctionDestination() {
  }

  public GoogleCloudFunctionDestination(String url, String type) {
    this.url = url;
    this.type = type;
  }

  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "GoogleCloudFunctionDestination{url='" + url + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GoogleCloudFunctionDestination that = (GoogleCloudFunctionDestination) o;
    return Objects.equals(url, that.url) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(url, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String url;

    private String type;

    public GoogleCloudFunctionDestination build() {
      GoogleCloudFunctionDestination result = new GoogleCloudFunctionDestination();
      result.url = this.url;
      result.type = this.type;
      return result;
    }

    public Builder url(String url) {
      this.url = url;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
