package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class GoogleCloudFunctionDestinationInput {
  private String url;

  public GoogleCloudFunctionDestinationInput() {
  }

  public GoogleCloudFunctionDestinationInput(String url) {
    this.url = url;
  }

  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  @Override
  public String toString() {
    return "GoogleCloudFunctionDestinationInput{url='" + url + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GoogleCloudFunctionDestinationInput that = (GoogleCloudFunctionDestinationInput) o;
    return Objects.equals(url, that.url);
  }

  @Override
  public int hashCode() {
    return Objects.hash(url);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String url;

    public GoogleCloudFunctionDestinationInput build() {
      GoogleCloudFunctionDestinationInput result = new GoogleCloudFunctionDestinationInput();
      result.url = this.url;
      return result;
    }

    public Builder url(String url) {
      this.url = url;
      return this;
    }
  }
}
