package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.String;
import java.util.List;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = ProductTailoringCreated.class, name = "ProductTailoringCreated"),
    @JsonSubTypes.Type(value = ProductTailoringData.class, name = "ProductTailoringData")
})
public interface HasProductTailoringData {
  String getName();

  void setName(String name);

  List<LocalizedString> getNameAllLocales();

  void setNameAllLocales(List<LocalizedString> nameAllLocales);

  String getDescription();

  void setDescription(String description);

  List<LocalizedString> getDescriptionAllLocales();

  void setDescriptionAllLocales(List<LocalizedString> descriptionAllLocales);

  String getSlug();

  void setSlug(String slug);

  List<LocalizedString> getSlugAllLocales();

  void setSlugAllLocales(List<LocalizedString> slugAllLocales);

  String getMetaTitle();

  void setMetaTitle(String metaTitle);

  List<LocalizedString> getMetaTitleAllLocales();

  void setMetaTitleAllLocales(List<LocalizedString> metaTitleAllLocales);

  String getMetaDescription();

  void setMetaDescription(String metaDescription);

  List<LocalizedString> getMetaDescriptionAllLocales();

  void setMetaDescriptionAllLocales(List<LocalizedString> metaDescriptionAllLocales);

  String getMetaKeywords();

  void setMetaKeywords(String metaKeywords);

  List<LocalizedString> getMetaKeywordsAllLocales();

  void setMetaKeywordsAllLocales(List<LocalizedString> metaKeywordsAllLocales);

  List<ProductVariantTailoring> getVariants();

  void setVariants(List<ProductVariantTailoring> variants);
}
