package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Currency;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class HighPrecisionMoney implements com.commercetools.graphql.api.types.BaseMoney {
  private String type;

  private Currency currencyCode;

  private Long preciseAmount;

  private Long centAmount;

  private Integer fractionDigits;

  public HighPrecisionMoney() {
  }

  public HighPrecisionMoney(String type, Currency currencyCode, Long preciseAmount, Long centAmount,
      Integer fractionDigits) {
    this.type = type;
    this.currencyCode = currencyCode;
    this.preciseAmount = preciseAmount;
    this.centAmount = centAmount;
    this.fractionDigits = fractionDigits;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public Currency getCurrencyCode() {
    return currencyCode;
  }

  public void setCurrencyCode(Currency currencyCode) {
    this.currencyCode = currencyCode;
  }

  public Long getPreciseAmount() {
    return preciseAmount;
  }

  public void setPreciseAmount(Long preciseAmount) {
    this.preciseAmount = preciseAmount;
  }

  public Long getCentAmount() {
    return centAmount;
  }

  public void setCentAmount(Long centAmount) {
    this.centAmount = centAmount;
  }

  public Integer getFractionDigits() {
    return fractionDigits;
  }

  public void setFractionDigits(Integer fractionDigits) {
    this.fractionDigits = fractionDigits;
  }

  @Override
  public String toString() {
    return "HighPrecisionMoney{type='" + type + "', currencyCode='" + currencyCode + "', preciseAmount='" + preciseAmount + "', centAmount='" + centAmount + "', fractionDigits='" + fractionDigits + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HighPrecisionMoney that = (HighPrecisionMoney) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(currencyCode, that.currencyCode) &&
        Objects.equals(preciseAmount, that.preciseAmount) &&
        Objects.equals(centAmount, that.centAmount) &&
        Objects.equals(fractionDigits, that.fractionDigits);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, currencyCode, preciseAmount, centAmount, fractionDigits);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private Currency currencyCode;

    private Long preciseAmount;

    private Long centAmount;

    private Integer fractionDigits;

    public HighPrecisionMoney build() {
      HighPrecisionMoney result = new HighPrecisionMoney();
      result.type = this.type;
      result.currencyCode = this.currencyCode;
      result.preciseAmount = this.preciseAmount;
      result.centAmount = this.centAmount;
      result.fractionDigits = this.fractionDigits;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder currencyCode(Currency currencyCode) {
      this.currencyCode = currencyCode;
      return this;
    }

    public Builder preciseAmount(Long preciseAmount) {
      this.preciseAmount = preciseAmount;
      return this;
    }

    public Builder centAmount(Long centAmount) {
      this.centAmount = centAmount;
      return this;
    }

    public Builder fractionDigits(Integer fractionDigits) {
      this.fractionDigits = fractionDigits;
      return this;
    }
  }
}
