package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class HttpDestinationAuthenticationInput {
  private AuthorizationHeaderInput AuthorizationHeader;

  private AzureFunctionsAuthenticationInput AzureFunctions;

  public HttpDestinationAuthenticationInput() {
  }

  public HttpDestinationAuthenticationInput(AuthorizationHeaderInput AuthorizationHeader,
      AzureFunctionsAuthenticationInput AzureFunctions) {
    this.AuthorizationHeader = AuthorizationHeader;
    this.AzureFunctions = AzureFunctions;
  }

  public AuthorizationHeaderInput getAuthorizationHeader() {
    return AuthorizationHeader;
  }

  public void setAuthorizationHeader(AuthorizationHeaderInput AuthorizationHeader) {
    this.AuthorizationHeader = AuthorizationHeader;
  }

  public AzureFunctionsAuthenticationInput getAzureFunctions() {
    return AzureFunctions;
  }

  public void setAzureFunctions(AzureFunctionsAuthenticationInput AzureFunctions) {
    this.AzureFunctions = AzureFunctions;
  }

  @Override
  public String toString() {
    return "HttpDestinationAuthenticationInput{AuthorizationHeader='" + AuthorizationHeader + "', AzureFunctions='" + AzureFunctions + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpDestinationAuthenticationInput that = (HttpDestinationAuthenticationInput) o;
    return Objects.equals(AuthorizationHeader, that.AuthorizationHeader) &&
        Objects.equals(AzureFunctions, that.AzureFunctions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(AuthorizationHeader, AzureFunctions);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AuthorizationHeaderInput AuthorizationHeader;

    private AzureFunctionsAuthenticationInput AzureFunctions;

    public HttpDestinationAuthenticationInput build() {
      HttpDestinationAuthenticationInput result = new HttpDestinationAuthenticationInput();
      result.AuthorizationHeader = this.AuthorizationHeader;
      result.AzureFunctions = this.AzureFunctions;
      return result;
    }

    public Builder AuthorizationHeader(AuthorizationHeaderInput AuthorizationHeader) {
      this.AuthorizationHeader = AuthorizationHeader;
      return this;
    }

    public Builder AzureFunctions(AzureFunctionsAuthenticationInput AzureFunctions) {
      this.AzureFunctions = AzureFunctions;
      return this;
    }
  }
}
