package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class HttpDestinationInput {
  private String url;

  private HttpDestinationAuthenticationInput authentication;

  public HttpDestinationInput() {
  }

  public HttpDestinationInput(String url, HttpDestinationAuthenticationInput authentication) {
    this.url = url;
    this.authentication = authentication;
  }

  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  public HttpDestinationAuthenticationInput getAuthentication() {
    return authentication;
  }

  public void setAuthentication(HttpDestinationAuthenticationInput authentication) {
    this.authentication = authentication;
  }

  @Override
  public String toString() {
    return "HttpDestinationInput{url='" + url + "', authentication='" + authentication + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpDestinationInput that = (HttpDestinationInput) o;
    return Objects.equals(url, that.url) &&
        Objects.equals(authentication, that.authentication);
  }

  @Override
  public int hashCode() {
    return Objects.hash(url, authentication);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String url;

    private HttpDestinationAuthenticationInput authentication;

    public HttpDestinationInput build() {
      HttpDestinationInput result = new HttpDestinationInput();
      result.url = this.url;
      result.authentication = this.authentication;
      return result;
    }

    public Builder url(String url) {
      this.url = url;
      return this;
    }

    public Builder authentication(HttpDestinationAuthenticationInput authentication) {
      this.authentication = authentication;
      return this;
    }
  }
}
