package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ImageInput {
  private String url;

  private String label;

  private DimensionsInput dimensions;

  public ImageInput() {
  }

  public ImageInput(String url, String label, DimensionsInput dimensions) {
    this.url = url;
    this.label = label;
    this.dimensions = dimensions;
  }

  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  public String getLabel() {
    return label;
  }

  public void setLabel(String label) {
    this.label = label;
  }

  public DimensionsInput getDimensions() {
    return dimensions;
  }

  public void setDimensions(DimensionsInput dimensions) {
    this.dimensions = dimensions;
  }

  @Override
  public String toString() {
    return "ImageInput{url='" + url + "', label='" + label + "', dimensions='" + dimensions + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ImageInput that = (ImageInput) o;
    return Objects.equals(url, that.url) &&
        Objects.equals(label, that.label) &&
        Objects.equals(dimensions, that.dimensions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(url, label, dimensions);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String url;

    private String label;

    private DimensionsInput dimensions;

    public ImageInput build() {
      ImageInput result = new ImageInput();
      result.url = this.url;
      result.label = this.label;
      result.dimensions = this.dimensions;
      return result;
    }

    public Builder url(String url) {
      this.url = url;
      return this;
    }

    public Builder label(String label) {
      this.label = label;
      return this;
    }

    public Builder dimensions(DimensionsInput dimensions) {
      this.dimensions = dimensions;
      return this;
    }
  }
}
