package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class InheritedStore {
  private Store store;

  private KeyReference storeRef;

  public InheritedStore() {
  }

  public InheritedStore(Store store, KeyReference storeRef) {
    this.store = store;
    this.storeRef = storeRef;
  }

  public Store getStore() {
    return store;
  }

  public void setStore(Store store) {
    this.store = store;
  }

  public KeyReference getStoreRef() {
    return storeRef;
  }

  public void setStoreRef(KeyReference storeRef) {
    this.storeRef = storeRef;
  }

  @Override
  public String toString() {
    return "InheritedStore{store='" + store + "', storeRef='" + storeRef + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    InheritedStore that = (InheritedStore) o;
    return Objects.equals(store, that.store) &&
        Objects.equals(storeRef, that.storeRef);
  }

  @Override
  public int hashCode() {
    return Objects.hash(store, storeRef);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Store store;

    private KeyReference storeRef;

    public InheritedStore build() {
      InheritedStore result = new InheritedStore();
      result.store = this.store;
      result.storeRef = this.storeRef;
      return result;
    }

    public Builder store(Store store) {
      this.store = store;
      return this;
    }

    public Builder storeRef(KeyReference storeRef) {
      this.storeRef = storeRef;
      return this;
    }
  }
}
