package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class InventoryEntryDeleted implements com.commercetools.graphql.api.types.MessagePayload {
  private String sku;

  private Channel supplyChannel;

  private Reference supplyChannelRef;

  private String type;

  public InventoryEntryDeleted() {
  }

  public InventoryEntryDeleted(String sku, Channel supplyChannel, Reference supplyChannelRef,
      String type) {
    this.sku = sku;
    this.supplyChannel = supplyChannel;
    this.supplyChannelRef = supplyChannelRef;
    this.type = type;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public Channel getSupplyChannel() {
    return supplyChannel;
  }

  public void setSupplyChannel(Channel supplyChannel) {
    this.supplyChannel = supplyChannel;
  }

  public Reference getSupplyChannelRef() {
    return supplyChannelRef;
  }

  public void setSupplyChannelRef(Reference supplyChannelRef) {
    this.supplyChannelRef = supplyChannelRef;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "InventoryEntryDeleted{sku='" + sku + "', supplyChannel='" + supplyChannel + "', supplyChannelRef='" + supplyChannelRef + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    InventoryEntryDeleted that = (InventoryEntryDeleted) o;
    return Objects.equals(sku, that.sku) &&
        Objects.equals(supplyChannel, that.supplyChannel) &&
        Objects.equals(supplyChannelRef, that.supplyChannelRef) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sku, supplyChannel, supplyChannelRef, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String sku;

    private Channel supplyChannel;

    private Reference supplyChannelRef;

    private String type;

    public InventoryEntryDeleted build() {
      InventoryEntryDeleted result = new InventoryEntryDeleted();
      result.sku = this.sku;
      result.supplyChannel = this.supplyChannel;
      result.supplyChannelRef = this.supplyChannelRef;
      result.type = this.type;
      return result;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder supplyChannel(Channel supplyChannel) {
      this.supplyChannel = supplyChannel;
      return this;
    }

    public Builder supplyChannelRef(Reference supplyChannelRef) {
      this.supplyChannelRef = supplyChannelRef;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
