package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class InventoryEntryQuantitySet implements com.commercetools.graphql.api.types.MessagePayload {
  private Long oldQuantityOnStock;

  private Long newQuantityOnStock;

  private Long oldAvailableQuantity;

  private Long newAvailableQuantity;

  private Channel supplyChannel;

  private Reference supplyChannelRef;

  private String type;

  public InventoryEntryQuantitySet() {
  }

  public InventoryEntryQuantitySet(Long oldQuantityOnStock, Long newQuantityOnStock,
      Long oldAvailableQuantity, Long newAvailableQuantity, Channel supplyChannel,
      Reference supplyChannelRef, String type) {
    this.oldQuantityOnStock = oldQuantityOnStock;
    this.newQuantityOnStock = newQuantityOnStock;
    this.oldAvailableQuantity = oldAvailableQuantity;
    this.newAvailableQuantity = newAvailableQuantity;
    this.supplyChannel = supplyChannel;
    this.supplyChannelRef = supplyChannelRef;
    this.type = type;
  }

  public Long getOldQuantityOnStock() {
    return oldQuantityOnStock;
  }

  public void setOldQuantityOnStock(Long oldQuantityOnStock) {
    this.oldQuantityOnStock = oldQuantityOnStock;
  }

  public Long getNewQuantityOnStock() {
    return newQuantityOnStock;
  }

  public void setNewQuantityOnStock(Long newQuantityOnStock) {
    this.newQuantityOnStock = newQuantityOnStock;
  }

  public Long getOldAvailableQuantity() {
    return oldAvailableQuantity;
  }

  public void setOldAvailableQuantity(Long oldAvailableQuantity) {
    this.oldAvailableQuantity = oldAvailableQuantity;
  }

  public Long getNewAvailableQuantity() {
    return newAvailableQuantity;
  }

  public void setNewAvailableQuantity(Long newAvailableQuantity) {
    this.newAvailableQuantity = newAvailableQuantity;
  }

  public Channel getSupplyChannel() {
    return supplyChannel;
  }

  public void setSupplyChannel(Channel supplyChannel) {
    this.supplyChannel = supplyChannel;
  }

  public Reference getSupplyChannelRef() {
    return supplyChannelRef;
  }

  public void setSupplyChannelRef(Reference supplyChannelRef) {
    this.supplyChannelRef = supplyChannelRef;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "InventoryEntryQuantitySet{oldQuantityOnStock='" + oldQuantityOnStock + "', newQuantityOnStock='" + newQuantityOnStock + "', oldAvailableQuantity='" + oldAvailableQuantity + "', newAvailableQuantity='" + newAvailableQuantity + "', supplyChannel='" + supplyChannel + "', supplyChannelRef='" + supplyChannelRef + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    InventoryEntryQuantitySet that = (InventoryEntryQuantitySet) o;
    return Objects.equals(oldQuantityOnStock, that.oldQuantityOnStock) &&
        Objects.equals(newQuantityOnStock, that.newQuantityOnStock) &&
        Objects.equals(oldAvailableQuantity, that.oldAvailableQuantity) &&
        Objects.equals(newAvailableQuantity, that.newAvailableQuantity) &&
        Objects.equals(supplyChannel, that.supplyChannel) &&
        Objects.equals(supplyChannelRef, that.supplyChannelRef) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(oldQuantityOnStock, newQuantityOnStock, oldAvailableQuantity, newAvailableQuantity, supplyChannel, supplyChannelRef, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Long oldQuantityOnStock;

    private Long newQuantityOnStock;

    private Long oldAvailableQuantity;

    private Long newAvailableQuantity;

    private Channel supplyChannel;

    private Reference supplyChannelRef;

    private String type;

    public InventoryEntryQuantitySet build() {
      InventoryEntryQuantitySet result = new InventoryEntryQuantitySet();
      result.oldQuantityOnStock = this.oldQuantityOnStock;
      result.newQuantityOnStock = this.newQuantityOnStock;
      result.oldAvailableQuantity = this.oldAvailableQuantity;
      result.newAvailableQuantity = this.newAvailableQuantity;
      result.supplyChannel = this.supplyChannel;
      result.supplyChannelRef = this.supplyChannelRef;
      result.type = this.type;
      return result;
    }

    public Builder oldQuantityOnStock(Long oldQuantityOnStock) {
      this.oldQuantityOnStock = oldQuantityOnStock;
      return this;
    }

    public Builder newQuantityOnStock(Long newQuantityOnStock) {
      this.newQuantityOnStock = newQuantityOnStock;
      return this;
    }

    public Builder oldAvailableQuantity(Long oldAvailableQuantity) {
      this.oldAvailableQuantity = oldAvailableQuantity;
      return this;
    }

    public Builder newAvailableQuantity(Long newAvailableQuantity) {
      this.newAvailableQuantity = newAvailableQuantity;
      return this;
    }

    public Builder supplyChannel(Channel supplyChannel) {
      this.supplyChannel = supplyChannel;
      return this;
    }

    public Builder supplyChannelRef(Reference supplyChannelRef) {
      this.supplyChannelRef = supplyChannelRef;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
