package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ItemShippingDetails {
  private List<ItemShippingTarget> targets;

  private Boolean valid;

  public ItemShippingDetails() {
  }

  public ItemShippingDetails(List<ItemShippingTarget> targets, Boolean valid) {
    this.targets = targets;
    this.valid = valid;
  }

  public List<ItemShippingTarget> getTargets() {
    return targets;
  }

  public void setTargets(List<ItemShippingTarget> targets) {
    this.targets = targets;
  }

  public Boolean getValid() {
    return valid;
  }

  public void setValid(Boolean valid) {
    this.valid = valid;
  }

  @Override
  public String toString() {
    return "ItemShippingDetails{targets='" + targets + "', valid='" + valid + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ItemShippingDetails that = (ItemShippingDetails) o;
    return Objects.equals(targets, that.targets) &&
        Objects.equals(valid, that.valid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(targets, valid);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<ItemShippingTarget> targets;

    private Boolean valid;

    public ItemShippingDetails build() {
      ItemShippingDetails result = new ItemShippingDetails();
      result.targets = this.targets;
      result.valid = this.valid;
      return result;
    }

    public Builder targets(List<ItemShippingTarget> targets) {
      this.targets = targets;
      return this;
    }

    public Builder valid(Boolean valid) {
      this.valid = valid;
      return this;
    }
  }
}
