package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ItemShippingDetailsDraftOutput {
  private List<ItemShippingTarget> targets;

  public ItemShippingDetailsDraftOutput() {
  }

  public ItemShippingDetailsDraftOutput(List<ItemShippingTarget> targets) {
    this.targets = targets;
  }

  public List<ItemShippingTarget> getTargets() {
    return targets;
  }

  public void setTargets(List<ItemShippingTarget> targets) {
    this.targets = targets;
  }

  @Override
  public String toString() {
    return "ItemShippingDetailsDraftOutput{targets='" + targets + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ItemShippingDetailsDraftOutput that = (ItemShippingDetailsDraftOutput) o;
    return Objects.equals(targets, that.targets);
  }

  @Override
  public int hashCode() {
    return Objects.hash(targets);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<ItemShippingTarget> targets;

    public ItemShippingDetailsDraftOutput build() {
      ItemShippingDetailsDraftOutput result = new ItemShippingDetailsDraftOutput();
      result.targets = this.targets;
      return result;
    }

    public Builder targets(List<ItemShippingTarget> targets) {
      this.targets = targets;
      return this;
    }
  }
}
