package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ItemStateDraftType {
  private Long quantity;

  private ReferenceInput state;

  public ItemStateDraftType() {
  }

  public ItemStateDraftType(Long quantity, ReferenceInput state) {
    this.quantity = quantity;
    this.state = state;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public ReferenceInput getState() {
    return state;
  }

  public void setState(ReferenceInput state) {
    this.state = state;
  }

  @Override
  public String toString() {
    return "ItemStateDraftType{quantity='" + quantity + "', state='" + state + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ItemStateDraftType that = (ItemStateDraftType) o;
    return Objects.equals(quantity, that.quantity) &&
        Objects.equals(state, that.state);
  }

  @Override
  public int hashCode() {
    return Objects.hash(quantity, state);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Long quantity;

    private ReferenceInput state;

    public ItemStateDraftType build() {
      ItemStateDraftType result = new ItemStateDraftType();
      result.quantity = this.quantity;
      result.state = this.state;
      return result;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }

    public Builder state(ReferenceInput state) {
      this.state = state;
      return this;
    }
  }
}
