package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class KeyReference {
  private String typeId;

  private String key;

  public KeyReference() {
  }

  public KeyReference(String typeId, String key) {
    this.typeId = typeId;
    this.key = key;
  }

  public String getTypeId() {
    return typeId;
  }

  public void setTypeId(String typeId) {
    this.typeId = typeId;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  @Override
  public String toString() {
    return "KeyReference{typeId='" + typeId + "', key='" + key + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KeyReference that = (KeyReference) o;
    return Objects.equals(typeId, that.typeId) &&
        Objects.equals(key, that.key);
  }

  @Override
  public int hashCode() {
    return Objects.hash(typeId, key);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String typeId;

    private String key;

    public KeyReference build() {
      KeyReference result = new KeyReference();
      result.typeId = this.typeId;
      result.key = this.key;
      return result;
    }

    public Builder typeId(String typeId) {
      this.typeId = typeId;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }
  }
}
