package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Long;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = CartDiscountLimitWithCurrent.class, name = "CartDiscountLimitWithCurrent"),
    @JsonSubTypes.Type(value = CartLimitWithCurrent.class, name = "CartLimitWithCurrent"),
    @JsonSubTypes.Type(value = CustomObjectLimitWithCurrent.class, name = "CustomObjectLimitWithCurrent"),
    @JsonSubTypes.Type(value = CustomerGroupLimitWithCurrent.class, name = "CustomerGroupLimitWithCurrent"),
    @JsonSubTypes.Type(value = CustomerLimitWithCurrent.class, name = "CustomerLimitWithCurrent"),
    @JsonSubTypes.Type(value = OrderEditLimitWithCurrent.class, name = "OrderEditLimitWithCurrent"),
    @JsonSubTypes.Type(value = ProductDiscountLimitWithCurrent.class, name = "ProductDiscountLimitWithCurrent"),
    @JsonSubTypes.Type(value = ProductTypeLimitWithCurrent.class, name = "ProductTypeLimitWithCurrent"),
    @JsonSubTypes.Type(value = RefreshTokenLimitWithCurrent.class, name = "RefreshTokenLimitWithCurrent"),
    @JsonSubTypes.Type(value = ShippingMethodLimitWithCurrent.class, name = "ShippingMethodLimitWithCurrent"),
    @JsonSubTypes.Type(value = ShoppingListLimitWithCurrent.class, name = "ShoppingListLimitWithCurrent"),
    @JsonSubTypes.Type(value = StoreLimitWithCurrent.class, name = "StoreLimitWithCurrent"),
    @JsonSubTypes.Type(value = TaxCategoryLimitWithCurrent.class, name = "TaxCategoryLimitWithCurrent"),
    @JsonSubTypes.Type(value = ZoneLimitWithCurrent.class, name = "ZoneLimitWithCurrent")
})
public interface LimitWithCurrent {
  Long getLimit();

  void setLimit(Long limit);

  Long getCurrent();

  void setCurrent(Long current);
}
