package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

public class LineItemDraft {
  private String key;

  private String productId;

  private String sku;

  private Long quantity;

  private Integer variantId;

  private ResourceIdentifierInput supplyChannel;

  private ResourceIdentifierInput distributionChannel;

  private CustomFieldsDraft custom;

  private ItemShippingDetailsDraft shippingDetails;

  private OffsetDateTime addedAt;

  private ExternalTaxRateDraft externalTaxRate;

  private BaseMoneyInput externalPrice;

  private ExternalLineItemTotalPriceDraft externalTotalPrice;

  private InventoryMode inventoryMode;

  public LineItemDraft() {
  }

  public LineItemDraft(String key, String productId, String sku, Long quantity, Integer variantId,
      ResourceIdentifierInput supplyChannel, ResourceIdentifierInput distributionChannel,
      CustomFieldsDraft custom, ItemShippingDetailsDraft shippingDetails, OffsetDateTime addedAt,
      ExternalTaxRateDraft externalTaxRate, BaseMoneyInput externalPrice,
      ExternalLineItemTotalPriceDraft externalTotalPrice, InventoryMode inventoryMode) {
    this.key = key;
    this.productId = productId;
    this.sku = sku;
    this.quantity = quantity;
    this.variantId = variantId;
    this.supplyChannel = supplyChannel;
    this.distributionChannel = distributionChannel;
    this.custom = custom;
    this.shippingDetails = shippingDetails;
    this.addedAt = addedAt;
    this.externalTaxRate = externalTaxRate;
    this.externalPrice = externalPrice;
    this.externalTotalPrice = externalTotalPrice;
    this.inventoryMode = inventoryMode;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getProductId() {
    return productId;
  }

  public void setProductId(String productId) {
    this.productId = productId;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public ResourceIdentifierInput getSupplyChannel() {
    return supplyChannel;
  }

  public void setSupplyChannel(ResourceIdentifierInput supplyChannel) {
    this.supplyChannel = supplyChannel;
  }

  public ResourceIdentifierInput getDistributionChannel() {
    return distributionChannel;
  }

  public void setDistributionChannel(ResourceIdentifierInput distributionChannel) {
    this.distributionChannel = distributionChannel;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public ItemShippingDetailsDraft getShippingDetails() {
    return shippingDetails;
  }

  public void setShippingDetails(ItemShippingDetailsDraft shippingDetails) {
    this.shippingDetails = shippingDetails;
  }

  public OffsetDateTime getAddedAt() {
    return addedAt;
  }

  public void setAddedAt(OffsetDateTime addedAt) {
    this.addedAt = addedAt;
  }

  public ExternalTaxRateDraft getExternalTaxRate() {
    return externalTaxRate;
  }

  public void setExternalTaxRate(ExternalTaxRateDraft externalTaxRate) {
    this.externalTaxRate = externalTaxRate;
  }

  public BaseMoneyInput getExternalPrice() {
    return externalPrice;
  }

  public void setExternalPrice(BaseMoneyInput externalPrice) {
    this.externalPrice = externalPrice;
  }

  public ExternalLineItemTotalPriceDraft getExternalTotalPrice() {
    return externalTotalPrice;
  }

  public void setExternalTotalPrice(ExternalLineItemTotalPriceDraft externalTotalPrice) {
    this.externalTotalPrice = externalTotalPrice;
  }

  public InventoryMode getInventoryMode() {
    return inventoryMode;
  }

  public void setInventoryMode(InventoryMode inventoryMode) {
    this.inventoryMode = inventoryMode;
  }

  @Override
  public String toString() {
    return "LineItemDraft{key='" + key + "', productId='" + productId + "', sku='" + sku + "', quantity='" + quantity + "', variantId='" + variantId + "', supplyChannel='" + supplyChannel + "', distributionChannel='" + distributionChannel + "', custom='" + custom + "', shippingDetails='" + shippingDetails + "', addedAt='" + addedAt + "', externalTaxRate='" + externalTaxRate + "', externalPrice='" + externalPrice + "', externalTotalPrice='" + externalTotalPrice + "', inventoryMode='" + inventoryMode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LineItemDraft that = (LineItemDraft) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(productId, that.productId) &&
        Objects.equals(sku, that.sku) &&
        Objects.equals(quantity, that.quantity) &&
        Objects.equals(variantId, that.variantId) &&
        Objects.equals(supplyChannel, that.supplyChannel) &&
        Objects.equals(distributionChannel, that.distributionChannel) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(shippingDetails, that.shippingDetails) &&
        Objects.equals(addedAt, that.addedAt) &&
        Objects.equals(externalTaxRate, that.externalTaxRate) &&
        Objects.equals(externalPrice, that.externalPrice) &&
        Objects.equals(externalTotalPrice, that.externalTotalPrice) &&
        Objects.equals(inventoryMode, that.inventoryMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, productId, sku, quantity, variantId, supplyChannel, distributionChannel, custom, shippingDetails, addedAt, externalTaxRate, externalPrice, externalTotalPrice, inventoryMode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private String productId;

    private String sku;

    private Long quantity;

    private Integer variantId;

    private ResourceIdentifierInput supplyChannel;

    private ResourceIdentifierInput distributionChannel;

    private CustomFieldsDraft custom;

    private ItemShippingDetailsDraft shippingDetails;

    private OffsetDateTime addedAt;

    private ExternalTaxRateDraft externalTaxRate;

    private BaseMoneyInput externalPrice;

    private ExternalLineItemTotalPriceDraft externalTotalPrice;

    private InventoryMode inventoryMode;

    public LineItemDraft build() {
      LineItemDraft result = new LineItemDraft();
      result.key = this.key;
      result.productId = this.productId;
      result.sku = this.sku;
      result.quantity = this.quantity;
      result.variantId = this.variantId;
      result.supplyChannel = this.supplyChannel;
      result.distributionChannel = this.distributionChannel;
      result.custom = this.custom;
      result.shippingDetails = this.shippingDetails;
      result.addedAt = this.addedAt;
      result.externalTaxRate = this.externalTaxRate;
      result.externalPrice = this.externalPrice;
      result.externalTotalPrice = this.externalTotalPrice;
      result.inventoryMode = this.inventoryMode;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder productId(String productId) {
      this.productId = productId;
      return this;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder supplyChannel(ResourceIdentifierInput supplyChannel) {
      this.supplyChannel = supplyChannel;
      return this;
    }

    public Builder distributionChannel(ResourceIdentifierInput distributionChannel) {
      this.distributionChannel = distributionChannel;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder shippingDetails(ItemShippingDetailsDraft shippingDetails) {
      this.shippingDetails = shippingDetails;
      return this;
    }

    public Builder addedAt(OffsetDateTime addedAt) {
      this.addedAt = addedAt;
      return this;
    }

    public Builder externalTaxRate(ExternalTaxRateDraft externalTaxRate) {
      this.externalTaxRate = externalTaxRate;
      return this;
    }

    public Builder externalPrice(BaseMoneyInput externalPrice) {
      this.externalPrice = externalPrice;
      return this;
    }

    public Builder externalTotalPrice(ExternalLineItemTotalPriceDraft externalTotalPrice) {
      this.externalTotalPrice = externalTotalPrice;
      return this;
    }

    public Builder inventoryMode(InventoryMode inventoryMode) {
      this.inventoryMode = inventoryMode;
      return this;
    }
  }
}
