package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class LocalizableEnumAttributeDefinitionType implements com.commercetools.graphql.api.types.AttributeDefinitionType {
  private LocalizableEnumValueTypeResult values;

  private String name;

  public LocalizableEnumAttributeDefinitionType() {
  }

  public LocalizableEnumAttributeDefinitionType(LocalizableEnumValueTypeResult values,
      String name) {
    this.values = values;
    this.name = name;
  }

  public LocalizableEnumValueTypeResult getValues() {
    return values;
  }

  public void setValues(LocalizableEnumValueTypeResult values) {
    this.values = values;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @Override
  public String toString() {
    return "LocalizableEnumAttributeDefinitionType{values='" + values + "', name='" + name + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LocalizableEnumAttributeDefinitionType that = (LocalizableEnumAttributeDefinitionType) o;
    return Objects.equals(values, that.values) &&
        Objects.equals(name, that.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(values, name);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private LocalizableEnumValueTypeResult values;

    private String name;

    public LocalizableEnumAttributeDefinitionType build() {
      LocalizableEnumAttributeDefinitionType result = new LocalizableEnumAttributeDefinitionType();
      result.values = this.values;
      result.name = this.name;
      return result;
    }

    public Builder values(LocalizableEnumValueTypeResult values) {
      this.values = values;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }
  }
}
